import 'reflect-metadata';
import 'dotenv/config';
import express from 'express';
import Container, { Service } from 'typedi';
import cors from 'cors';
import morgan from 'morgan';
import Routerr from './src/Routes';
import AdminAdapter from './src/Database/adapters/adminAdapter';
import fileUpload from 'express-fileupload';

@Service()
class App {
    public app: express.Application;
    public env: string;
    public port: string | number;

    constructor(
        private readonly routerr: Routerr,
        private readonly adminAdapter: AdminAdapter
    ) {
        this.app = express();
        this.env = process.env.NODE_ENV || 'development';
        // this.port = process.env.PORT || 7010;
        this.port = process.env.PORT!;

        this.initializeMiddlewares();
        this.initializeRoutes()
    }

    private initializeRoutes = () => {
        this.app.use(this.routerr.path, this.routerr.router);
        this.app.use(fileUpload({
            limits: { fileSize: 50 * 1024 * 1024 },
        }));
    }

    private initializeMiddlewares() {
        this.app.get('/', (req: any, res: any) => res.json({ msg: 'HELLOOOO' }))
        this.app.use(morgan(process.env.LOG_FORMAT || 'dev'));
        this.app.use(cors());
        this.app.use(express.json());
        this.app.use(express.urlencoded({ extended: true }));
        this.app.use((req, res, next) => {
            res.header('Access-Control-Expose-Headers', 'Content-Disposition');
            next();
        });
    }

    public getServer() {
        return this.app;
    }

    public listen() {
        this.app.listen(this.port, async () => {
            console.info(`=================================`);
            console.info(`======= ENV: ${this.env} ========`);
            console.info(`🚀 App listening on the port ${this.port}`);
            console.info(`=================================`);

            this.adminAdapter.DBCreateSuperAdmin().then(r => {
                console.info("Super admin account created successfully!")
            })

            process
                .on('unhandledRejection', (reason, p) => {
                    console.error(reason, 'Unhandled Rejection at Promise', p);
                })
                .on('uncaughtException', err => {
                    console.error(err, 'Uncaught Exception thrown');
                    process.exit(1);
                });
        });
    }
}

const instance = Container.get(App);
instance.listen();

const app = instance.getServer();

export default app;

