"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AspirantValidatorAdapter = void 0;
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const _1 = tslib_1.__importStar(require("."));
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
const factory_1 = require("../../Utils/factory");
let AspirantAdapter = class AspirantAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.DBGetProgrammeByStream = (stream) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const programme = yield _1.default.select('*').from(db_types_1.ETables.PROGRAMME).where("stream", stream).first();
                return programme;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetProfProgrammes = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const programme = yield _1.default.select('*').from(db_types_1.ETables.PROGRAMME).whereNotIn("stream", [enum_1.Stream.FULL, enum_1.Stream.PART]);
                return programme;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBCreateProfAspirant = (data, stream, session_id, diet_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const programme = yield _1.default.select('*').from(db_types_1.ETables.PROGRAMME).where('stream', stream).first();
                // const year = new Date().getUTCFullYear();
                const [aspirant] = yield (0, _1.default)(db_types_1.ETables.PROF_ASPIRANT).insert(Object.assign(Object.assign({}, data), { programme_id: programme.id, session_id, diet_id }));
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetProfAspirant = (email) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select([
                    "aspi.first_name as first_name",
                    "aspi.last_name as last_name",
                    "aspi.middle_name as middle_name",
                    "aspi.email as email",
                    "aspi.qualification as qualification",
                    "aspi.workplace as workplace",
                    "aspi.years_of_exp as years_of_exp",
                    "aspi.certificate as certificate",
                    "aspi.paid as paid",
                    "aspi.status as status",
                    'prog.id as programme_id',
                    'prog.name as programme_name',
                    'prog.duration as programme_duration',
                    'prog.stream as programme_stream',
                    'prog.open_to_application as programme_available',
                    // 'diet.number as diet',
                    // 'diet.year as year',
                    // 'diet.session_id as session',
                    // 'diet.is_current as is_current_diet',
                ]).from({ aspi: db_types_1.ETables.PROF_ASPIRANT })
                    .join({ prog: db_types_1.ETables.PROGRAMME }, 'prog.id', 'aspi.programme_id')
                    // .join({ diet: ETables.DIET }, 'diet.id', 'aspi.diet_id')
                    .where("email", email).first();
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBCreateApplication = (data, email, stream) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const programme = yield _1.default.select(['id']).from(db_types_1.ETables.PROGRAMME).where('stream', stream).first();
                yield (0, _1.default)(db_types_1.ETables.PROF_ASPIRANT).update(Object.assign(Object.assign({}, data), { status: enum_1.Status.PENDING })).where('email', email).andWhere('programme_id', programme.id);
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // NID
        this.DBPUTMERegistration = (data, reg_no, programme_id, session) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const [aspirant] = yield (0, _1.default)(db_types_1.ETables.ASPIRANT).insert(Object.assign(Object.assign({}, data), { reg_no, programme_id, session_id: session.id, diet_id: session.current_diet.id }));
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBPartApplication = (data, reg_no, programme_id, session) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const serializedManualOLevel = JSON.stringify(data.manual_o_level);
                const [aspirant] = yield (0, _1.default)(db_types_1.ETables.ASPIRANT).insert(Object.assign(Object.assign({}, data), { manual_o_level: serializedManualOLevel, reg_no, programme_id, session_id: session.id, diet_id: session.current_diet.id }));
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAspirant = (jamb_reg) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select([
                    'aspi.*',
                    'prog.stream as programme_stream',
                ])
                    .from({ aspi: db_types_1.ETables.ASPIRANT }).where('aspi.jamb_reg', jamb_reg)
                    .join({ prog: db_types_1.ETables.PROGRAMME }, 'prog.id', 'aspi.programme_id').first();
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAspirantByEmail = (email) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select([
                    'aspi.*',
                    'prog.stream as programme_stream',
                ])
                    .from({ aspi: db_types_1.ETables.ASPIRANT }).where('aspi.email', email)
                    .join({ prog: db_types_1.ETables.PROGRAMME }, 'prog.id', 'aspi.programme_id').first();
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // public DBUploadAdmissionLetter = async (jamb_reg: string, data: { adm_letter: Buffer, adm_letter_mimetype: string }) => {
        this.DBUploadAdmissionLetter = (jamb_reg, data) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select('*').from(db_types_1.ETables.ASPIRANT).where('jamb_reg', jamb_reg).first();
                yield (0, _1.default)(db_types_1.ETables.ASPIRANT).update(Object.assign({}, data)).where('jamb_reg', jamb_reg).andWhere('id', aspirant.id);
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // BOTH
        this.DBUpdateAcceptancePaymentStatus = (id, jamb_reg) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            console.log(id, 'idDDDDddd');
            try {
                if (!jamb_reg) {
                    yield (0, _1.default)(db_types_1.ETables.PROF_ASPIRANT).update({ paid: true }).where('id', id);
                }
                else {
                    yield (0, _1.default)(db_types_1.ETables.ASPIRANT).update({ paid: true }).where('id', id).andWhere('jamb_reg', jamb_reg);
                }
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // public DBCreateStudent = async ({}) => {
        //     try {
        //     } catch (error) {
        //         return this.catchError(error);
        //     }
        // }
        this.DBTransferReceipt = (id, student_id, stream) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                let column = '';
                // stream == Stream.STANDARD ? column = 'aspirant_id' : column = 'prof_aspirant_id';
                Object.values(enum_1.NID_Stream).includes(stream) ? column = 'aspirant_id' : column = 'prof_aspirant_id';
                yield _1.default.transaction((trx) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    const receipt = yield trx.select('*').from(db_types_1.ETables.ASPIRANT_FEE).where(column, id);
                    // Check if receipt is empty
                    if (receipt.length === 0) {
                        console.error('No records found for the given column and ID:', column, id);
                        throw new Error('No records found to transfer.');
                    }
                    for (let fee of receipt) {
                        delete fee.id;
                        delete fee.prof_aspirant_id;
                        delete fee.aspirant_id;
                        fee.student_id = student_id;
                    }
                    // Insert into STUDENT_FEE
                    yield trx(db_types_1.ETables.STUDENT_FEE).insert(receipt);
                    console.log(`Successfully inserted ${receipt.length} records into ${db_types_1.ETables.STUDENT_FEE}`);
                    // Delete from ASPIRANT_FEE
                    const deletedCount = yield trx(db_types_1.ETables.ASPIRANT_FEE).where(column, id).delete();
                    console.log(`Successfully deleted ${deletedCount} records from ${db_types_1.ETables.ASPIRANT_FEE}`);
                }));
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // public DBRemoveAspirant = async (id: number, email: string, stream: Stream, student_id: number) => {
        this.DBCreateEnrollmentV1 = (id, email, stream, student_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                // stream == Stream.STANDARD && await knex(ETables.ASPIRANT).where('id', id).andWhere("email", email).delete();
                // stream != Stream.STANDARD && await knex(ETables.PROF_ASPIRANT).where('id', id).andWhere("email", email).delete();
                yield _1.default.transaction((trx) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    let data;
                    let columns;
                    if (stream === enum_1.Stream.FULL) {
                        columns = [
                            'o_level', 'o_level_mimetype', 'jamb_result', 'jamb_result_mimetype',
                            'adm_letter', 'adm_letter_mimetype'
                        ];
                    }
                    else if (stream === enum_1.Stream.PART) {
                        columns = [
                            'o_level', 'o_level_mimetype',
                            'adm_letter', 'adm_letter_mimetype'
                        ];
                    }
                    if (columns) {
                        data = yield trx.select(columns)
                            .from(db_types_1.ETables.ASPIRANT)
                            .where("id", id)
                            .andWhere("email", email)
                            .first();
                        yield trx(db_types_1.ETables.ENROLLMENT)
                            .where("student_id", student_id)
                            .update(data);
                        // Removing the delete aspiant and prof_aspirant for data record and to keep track of the right registration no
                        // await trx(ETables.ASPIRANT)
                        //     .where("id", id)
                        //     .andWhere("email", email)
                        //     .delete();
                    }
                    else {
                        // await trx(ETables.PROF_ASPIRANT)
                        //     .where("id", id)
                        //     .andWhere("email", email)
                        //     .delete();
                    }
                }));
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBCreateEnrollmentV2 = (user_id, common_data, programme_duration) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                yield _1.default.transaction((trx) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                    let data;
                    let columns;
                    if (common_data.stream === enum_1.Stream.FULL) {
                        columns = [
                            'jamb_reg',
                            'o_level_path', 'o_level_mimetype', 'jamb_result_path', 'jamb_result_mimetype',
                            'adm_letter_path', 'adm_letter_mimetype'
                        ];
                    }
                    else if (common_data.stream === enum_1.Stream.PART) {
                        columns = [
                            'o_level', 'o_level_mimetype',
                            'passport_path', 'passport_mimetype'
                        ];
                    }
                    else {
                        columns = [
                            'qualification', 'workplace', 'years_of_exp',
                            'certificate_mimetype', 'certificate_path'
                        ];
                    }
                    if (!columns)
                        throw new Error();
                    if (common_data.stream === enum_1.Stream.FULL || common_data.stream === enum_1.Stream.PART) {
                        data = yield trx.select(columns)
                            .from(db_types_1.ETables.ASPIRANT)
                            .where("id", user_id)
                            .first();
                    }
                    else {
                        data = yield trx.select(columns)
                            .from(db_types_1.ETables.PROF_ASPIRANT)
                            .where("id", user_id)
                            .first();
                    }
                    const completion_date = (0, factory_1.getCompletionDateV2)(programme_duration);
                    const enrollment_date = new Date().toISOString().split('T')[0];
                    console.log({ enrollment_date, completion_date });
                    yield trx(db_types_1.ETables.ENROLLMENT).insert(Object.assign(Object.assign(Object.assign({}, common_data), data), { completion_date, enrollment_date }));
                    yield trx(db_types_1.ETables.ASPIRANT).where("id", user_id).delete();
                }));
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
AspirantAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], AspirantAdapter);
let AspirantValidatorAdapter = class AspirantValidatorAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.DBCheckApplicationEmail = (email) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select(['email', 'status']).from(db_types_1.ETables.PROF_ASPIRANT).where("email", email).first();
                const student = yield _1.default.select(['email', 'status']).from(db_types_1.ETables.STUDENT).where("email", email).first();
                return aspirant || student;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetProfAspirant = (email) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select('*')
                    .from({ aspi: db_types_1.ETables.PROF_ASPIRANT })
                    .join({ prog: db_types_1.ETables.PROGRAMME }, 'prog.id', 'aspi.programme_id')
                    .where("email", email).first();
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAcceptedProfAspirant = (email) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select('*')
                    .from({ aspi: db_types_1.ETables.PROF_ASPIRANT })
                    .join({ prog: db_types_1.ETables.PROGRAMME }, 'prog.id', 'aspi.programme_id')
                    .where("email", email).andWhere('status', 'accepted').first();
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // NID
        this.DBCheckScreeningEmail = (email) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select('*').from(db_types_1.ETables.ASPIRANT).where("email", email).first();
                const student = yield _1.default.select(['email', 'status']).from(db_types_1.ETables.STUDENT).where("email", email).first();
                return aspirant || student;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBCheckJambReg = (jamb_reg) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select('*').from(db_types_1.ETables.ASPIRANT).where("jamb_reg", jamb_reg).first();
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAcceptedAspirant = (jamb_reg) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select('*')
                    .from(db_types_1.ETables.ASPIRANT)
                    .where("jamb_reg", jamb_reg).andWhere('status', 'accepted').first();
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAspirant = (jamb_reg) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select('*')
                    .from(db_types_1.ETables.ASPIRANT)
                    .where("jamb_reg", jamb_reg).first();
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAspirantByEmail = (email) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const aspirant = yield _1.default.select('*')
                    .from(db_types_1.ETables.ASPIRANT)
                    .where("email", email).first();
                return aspirant;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
exports.AspirantValidatorAdapter = AspirantValidatorAdapter;
exports.AspirantValidatorAdapter = AspirantValidatorAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], AspirantValidatorAdapter);
exports.default = AspirantAdapter;
