"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FeeValidatorAdapter = void 0;
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const _1 = tslib_1.__importStar(require("."));
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
let FeeAdapter = class FeeAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.DBCreateAspirantFee = (id, fee, amount_paid, stream, reference, session) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                // stream = !stream ? Stream.STANDARD : stream
                const obj = {
                    amount_paid,
                    amount_due: fee.amount,
                    stream,
                    year: new Date().getFullYear(),
                    completed: amount_paid == fee.amount,
                    balance: fee.amount - amount_paid,
                    reference,
                    diet_id: session.current_diet.id,
                    fee_id: fee.id,
                    // prof_aspirant_id: stream !== Stream.STANDARD ? id : null,
                    prof_aspirant_id: !(Object.values(enum_1.NID_Stream).includes(stream)) ? id : null,
                    // aspirant_id: stream === Stream.STANDARD ? id : null,
                    aspirant_id: Object.values(enum_1.NID_Stream).includes(stream) ? id : null,
                    // programme_id,
                    session_id: session.id
                };
                yield _1.default.select('*').from(db_types_1.ETables.ASPIRANT_FEE).insert(obj);
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBCreateStudentFee = (student_id, fee, amount_paid, stream, reference, programme_id, session, residual) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            var _a;
            try {
                const records = yield _1.default.select('*').from(db_types_1.ETables.STUDENT_FEE).where('student_id', student_id).andWhere('session_id', session.id);
                console.log(fee, 'fee');
                console.log(records, 'records');
                if (residual) {
                    // for(let record of records) {
                    //     if(record.id === fee.id)
                    // }
                    const found = records.find(record => record.fee_id === Number(fee.id));
                    console.log(found, 'almost');
                    const total_amount_paid = Number(found.amount_paid) + Number(amount_paid);
                    yield (0, _1.default)(db_types_1.ETables.STUDENT_FEE).update({
                        amount_paid: total_amount_paid,
                        balance: found.amount_due - total_amount_paid,
                        completed: found.amount_due == total_amount_paid
                    }).where('fee_id', fee.id);
                    return;
                }
                const obj = {
                    amount_paid,
                    amount_due: fee.amount,
                    stream,
                    year: new Date().getFullYear(),
                    completed: amount_paid == fee.amount,
                    balance: fee.amount - amount_paid,
                    reference,
                    diet_id: (_a = session === null || session === void 0 ? void 0 : session.current_diet) === null || _a === void 0 ? void 0 : _a.id,
                    // diet_id: stream == Stream.STANDARD ? null : session?.current_diet?.id,
                    fee_id: fee.id,
                    student_id,
                    programme_id,
                    session_id: session.id
                };
                yield (0, _1.default)(db_types_1.ETables.STUDENT_FEE).insert(obj);
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetProfFormFee = (session_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const fee = yield _1.default.select('*').from(db_types_1.ETables.FEE).where("name", enum_1.Fee_Type.FORM).andWhere("category", enum_1.Category.PROFESSIONAL).andWhere("session_id", session_id).first();
                fee.amount = Number(fee.amount);
                return fee;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // NID
        this.DBGetPUTMFee = (session_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const fee = yield _1.default.select('*').from(db_types_1.ETables.FEE).where('name', enum_1.Fee_Type.PUTME).andWhere("session_id", session_id).first();
                fee.amount = Number(fee.amount);
                return fee;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetPartApplicationFee = (session_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const fee = yield _1.default.select('*').from(db_types_1.ETables.FEE).where('name', enum_1.Fee_Type.PART_FORM).andWhere("session_id", session_id).first();
                fee.amount = Number(fee.amount);
                return fee;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetSchoolFee = (category, session_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const fee = yield _1.default.select('*').from(db_types_1.ETables.FEE).where('name', enum_1.Fee_Type.TUITION).andWhere('category', category).andWhere("session_id", session_id).first();
                fee.amount = Number(fee.amount);
                return fee;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // BOTH
        this.DBGetIDCardFee = (session_id, category) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const fee = yield _1.default.select('*').from(db_types_1.ETables.FEE).where("name", enum_1.Fee_Type.ID_CARD).andWhere("category", category).andWhere("session_id", session_id).first();
                fee.amount = Number(fee.amount);
                console.log(fee, 'IDCARDDDDD');
                return fee;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetAcceptanceFee = (session_id, category) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const fee = yield _1.default.select('*').from(db_types_1.ETables.FEE).where("name", enum_1.Fee_Type.ACCEPTANCE).andWhere("category", category).andWhere("session_id", session_id).first();
                fee.amount = Number(fee.amount);
                return fee;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // STUDENTTTTTTTT
        this.DBGetOutstandingFee = (user_id, session_id, stream, residual) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                console.log(residual, 'outstandingggg');
                let fees = [];
                let fees_to_balance = [];
                const paid_fees = yield _1.default.select('*').from(db_types_1.ETables.STUDENT_FEE).where('student_id', user_id).andWhere('session_id', session_id);
                // const paid_fees = await knex.select('*').from(ETables.ASPIRANT_FEE).where('prof_aspirant_id', 1).andWhere('session_id', session_id);
                // console.log(paid_fees, 'paid_fees')
                // if not paid fees, that means it's a new session and the student is returning
                // if (!paid_fees && stream == 'standard') {
                if (!paid_fees && Object.values(enum_1.NID_Stream).includes(stream)) {
                    const fees = yield _1.default.select('*').from(db_types_1.ETables.FEE).where('category', stream);
                    console.log('It is a new a session');
                    return fees;
                }
                for (let fee of paid_fees) {
                    if (fee.completed)
                        continue;
                    fees_to_balance.push({
                        fee_id: fee.fee_id,
                        balance: Number(fee.balance)
                    });
                }
                ;
                // console.log(fees_to_balance, 'fees_to_balance')
                if (!fees_to_balance.length)
                    return fees;
                const outstanding = yield _1.default.select('*').from(db_types_1.ETables.FEE).whereIn('id', fees_to_balance.map(fee => fee.fee_id));
                // console.log(outstanding, 'outstanding')
                // process it and get the balnce and push oit to fees above but for ---------  later
                for (let fee of outstanding) {
                    for (let bal of fees_to_balance) {
                        if (bal.fee_id === fee.id && bal.balance) {
                            fee.amount = Number(bal.balance);
                            fee.upfront = false;
                            residual;
                        }
                    }
                }
                return outstanding;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        // TEST
        this.DBTest = () => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const fees = yield _1.default.select('*').from(db_types_1.ETables.FEE);
                return fees;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
FeeAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], FeeAdapter);
let FeeValidatorAdapter = class FeeValidatorAdapter extends _1.BaseAdapter {
    constructor() {
        super();
        this.DBDoesProgrammeExist = (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const programme = yield _1.default.select('*').from(db_types_1.ETables.PROGRAMME).where("id", id).first();
                return programme;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBIsProgrammeOpenToAdmission = (stream) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const open = yield _1.default.select('*').from(db_types_1.ETables.PROGRAMME).where('stream', stream).andWhere('open_to_application', true).first();
                return !!open;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBFeeExist = (id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const fee = yield _1.default.select('*').from(db_types_1.ETables.FEE).where('id', id).first();
                return !!fee;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBIsFeeSplittable = (name, category) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const splittable = yield _1.default.select('*').from(db_types_1.ETables.FEE).where('name', name).andWhere('category', category).andWhere('upfront', true).first();
                return !!splittable;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBGetFeeByNameAndCategory = (name, category) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const fee = yield _1.default.select('*').from(db_types_1.ETables.FEE).where('name', name).andWhere('category', category).first();
                return fee;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBHasPaidFee = (fee_id, user_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const paid = yield _1.default.select('*').from(db_types_1.ETables.ASPIRANT_FEE).where({ fee_id, prof_aspirant_id: user_id }).first();
                return !!paid;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
        this.DBCheckOutstandingFee = (user_id, session_id, stream, residual) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                let fees = [];
                let fees_to_balance = [];
                const paid_fees = yield _1.default.select('*').from(db_types_1.ETables.STUDENT_FEE).where('student_id', user_id).andWhere('session_id', session_id);
                // if (!paid_fees && stream == 'standard') {
                if (!paid_fees && Object.values(enum_1.NID_Stream).includes(stream)) {
                    const fees = yield _1.default.select('*').from(db_types_1.ETables.FEE).where('category', stream);
                    console.log('It is a new a session');
                    return !!fees.length;
                }
                for (let fee of paid_fees) {
                    if (fee.completed)
                        continue;
                    fees_to_balance.push({
                        fee_id: fee.fee_id,
                        balance: Number(fee.balance)
                    });
                }
                ;
                if (!fees_to_balance.length)
                    return !!fees.length;
                const outstanding = yield _1.default.select('*').from(db_types_1.ETables.FEE).whereIn('id', fees_to_balance.map(fee => fee.fee_id));
                for (let fee of outstanding) {
                    for (let bal of fees_to_balance) {
                        if (bal.fee_id === fee.id && bal.balance) {
                            fee.amount = Number(bal.balance);
                            fee.upfront = false;
                            residual;
                        }
                    }
                }
                console.log(outstanding, 'oout');
                return !!outstanding.length;
            }
            catch (error) {
                return this.catchError(error);
            }
        });
    }
};
exports.FeeValidatorAdapter = FeeValidatorAdapter;
exports.FeeValidatorAdapter = FeeValidatorAdapter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [])
], FeeValidatorAdapter);
exports.default = FeeAdapter;
