"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseAdapter = void 0;
// import { DB_HOST, DB_NAME, DB_PASS, DB_PORT, DB_URL, DB_USER } from '@/Config';
// import { logger } from '@/Logger';
const knex_1 = require("knex");
const knexConfig = {
    client: 'mysql2',
    connection: process.env.DATABASE_URL,
    pool: {
        min: 2,
        max: 10
    },
    timezone: 'UTC'
};
const knex = (0, knex_1.knex)(knexConfig);
class BaseAdapter {
    constructor() {
        this.catchError = (error) => {
            // logger.error(error);
            console.error(error);
            throw new Error("Failed at db level");
        };
    }
}
exports.BaseAdapter = BaseAdapter;
exports.default = knex;
