"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
const dotenv_1 = require("dotenv");
const env = process.env.NODE_ENV || 'development';
const envFilePath = env === 'production'
    ? './../../../.env'
    : './../../.env';
(0, dotenv_1.config)({ path: envFilePath });
const knexConfig = {
    client: 'mysql2',
    connection: (_a = process.env.DATABASE_URL) !== null && _a !== void 0 ? _a : {
        user: process.env.DB_USER,
        password: process.env.DB_PASS,
        database: process.env.DB_NAME,
        host: process.env.DB_HOST,
        // server: process.env.DB_HOST, 
        port: process.env.DB_PORT
    },
    pool: {
        min: 2,
        max: 10
    },
    migrations: {
        tableName: 'knex_migrations',
        directory: 'migrations',
        extensions: 'ts'
    },
    seeds: {
        directory: 'seeds',
        extensions: 'ts',
        order: ['seed_session.ts', 'seed_programme.ts', 'seed_fee.ts']
    },
    timezone: 'UTC',
};
exports.default = knexConfig;
