"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.ACADEMIC_SESSION, (table) => {
            table.increments("id", { primaryKey: true });
            table.string("name", 255).notNullable().unique();
            table.date("start_date").notNullable();
            table.date("end_date").notNullable();
            table.boolean("is_current").notNullable().defaultTo(false);
            table.enu('current_semester', Object.values(enum_1.Semester));
            table.timestamps(true, true);
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.ACADEMIC_SESSION);
    });
}
exports.down = down;
