"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.PROGRAMME, (table) => {
            table.increments("id", { primaryKey: true });
            table.string("name", 255).notNullable();
            table.text("description", "longtext");
            // table.bigInteger("duration").notNullable();
            table.string("duration").notNullable();
            table.enum("stream", Object.values(enum_1.Stream)).notNullable().unique();
            table.boolean('open_to_application').notNullable().defaultTo(true);
            table.timestamps(true, true);
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.PROGRAMME);
    });
}
exports.down = down;
