"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.DIET, (table) => {
            table.increments("id", { primaryKey: true });
            table.integer("number").notNullable();
            table.integer("year").notNullable();
            table.boolean('is_current').notNullable().defaultTo(false);
            table.integer("session_id").unsigned();
            table.foreign("session_id").references("id").inTable(db_types_1.ETables.ACADEMIC_SESSION);
            table.timestamps(true, true);
            table.unique(["number", "year", "session_id"], { indexName: "unique_DIET_year_session" });
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.DIET);
    });
}
exports.down = down;
