"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.PROF_ASPIRANT, (table) => {
            table.increments("id", { primaryKey: true });
            table.string("first_name", 255).notNullable();
            table.string("last_name", 255).notNullable();
            table.string("middle_name", 255);
            table.string("email").unique().notNullable();
            table.string("password");
            table.date('DOB');
            table.enum("gender", Object.values(enum_1.Gender)).notNullable();
            table.string("phone").notNullable();
            table.string("qualification");
            table.string("workplace");
            table.integer('years_of_exp');
            table.binary("certificate");
            table.string('mimetype');
            table.boolean('paid').notNullable().defaultTo(false);
            // table.enum("status", Object.values(Status)).notNullable().defaultTo(Status.PENDING);
            table.enum("status", Object.values(enum_1.Status));
            table.specificType("passport", 'LONGBLOB').notNullable();
            table.string('passport_mimetype');
            table.integer("diet_id").unsigned();
            table.foreign("diet_id").references("id").inTable(db_types_1.ETables.DIET);
            table.integer("programme_id").unsigned();
            table.foreign("programme_id").references("id").inTable(db_types_1.ETables.PROGRAMME);
            table.integer("session_id").unsigned();
            table.foreign("session_id").references("id").inTable(db_types_1.ETables.ACADEMIC_SESSION);
            table.timestamps(true, true);
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.PROF_ASPIRANT);
    });
}
exports.down = down;
