"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.ENROLLMENT, (table) => {
            table.increments("id", { primaryKey: true });
            table.string('jamb_reg');
            table.date('enrollment_date').notNullable();
            table.date('completion_date').notNullable();
            table.string("qualification");
            table.string("workplace");
            table.integer('years_of_exp');
            table.binary("certificate");
            table.string('certificate_mimetype');
            table.binary("o_level");
            table.string('o_level_mimetype');
            table.binary("jamb_result");
            table.string('jamb_result_mimetype');
            table.binary("adm_letter");
            table.string('adm_letter_mimetype');
            table.enu('stream', Object.values(enum_1.Stream)).notNullable();
            table.integer("entry_session").unsigned();
            table.foreign("entry_session").references("id").inTable(db_types_1.ETables.ACADEMIC_SESSION);
            table.integer("student_id").unsigned();
            table.foreign("student_id").references("id").inTable(db_types_1.ETables.STUDENT);
            table.integer("programme_id").unsigned();
            table.foreign("programme_id").references("id").inTable(db_types_1.ETables.PROGRAMME);
            table.integer("diet_id").unsigned();
            table.foreign("diet_id").references("id").inTable(db_types_1.ETables.DIET);
            table.integer("session_id").unsigned();
            table.foreign("session_id").references("id").inTable(db_types_1.ETables.ACADEMIC_SESSION);
            table.timestamps(true, true);
        });
        // .raw(`
        //   ALTER TABLE ${ETables.ENROLLMENT}
        //   ADD CONSTRAINT chk_stream_type_nullability
        //   CHECK (
        //     (stream = 'standard' AND o_level IS NOT NULL AND jamb_result IS NOT NULL AND adm_letter IS NOT NULL)
        //   )
        // `);
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.ENROLLMENT);
    });
}
exports.down = down;
