"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.COURSES, (table) => {
            table.increments("id", { primaryKey: true });
            table.string("code").notNullable().unique();
            table.string("title", 255).notNullable();
            table.text("description", "longtext").notNullable();
            table.integer("unit").unsigned().notNullable();
            table.enum("type", Object.values(enum_1.Course_Type)).defaultTo(enum_1.Course_Type.CORE);
            table.enu('level', Object.values(enum_1.Level)); // the level of teh course opriginally
            table.enu('semester', Object.values(enum_1.Semester));
            table.enum("stream", Object.values(enum_1.Stream)).notNullable();
            table.timestamp("deleted_at");
            table.timestamps(true, true);
        });
        // .raw(`
        //     ALTER TABLE ${ETables.COURSES} 
        //     ADD CONSTRAINT CHECK_stream_semester 
        //     CHECK ((stream IN ('basic', 'advanced') AND semester IS NULL) OR (stream = 'standard' AND semester IS NOT NULL))
        // `)
        // .raw(`
        //     ALTER TABLE ${ETables.COURSES} 
        //     ADD CONSTRAINT CHECK_stream_level 
        //     CHECK ((stream IN ('basic', 'advanced') AND level IS NULL) OR (stream = 'standard' AND level IS NOT NULL))
        // `)
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.COURSES);
    });
}
exports.down = down;
