"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.GRADE, (table) => {
            table.increments('id').primary();
            table.integer('mark_min').notNullable();
            table.integer('mark_max').notNullable();
            table.string('letter_grade', 2).notNullable();
            table.decimal('weight', 3, 2).notNullable();
        })
            .createTable(db_types_1.ETables.CGPA_GRADE, table => {
            table.increments('id').primary();
            table.decimal('mark_min', 3, 2).notNullable();
            table.decimal('mark_max', 3, 2).notNullable();
            table.enum('class', Object.values(enum_1.COD)).notNullable();
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.CGPA_GRADE)
            .dropTable(db_types_1.ETables.GRADE);
    });
}
exports.down = down;
