"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.createTable(db_types_1.ETables.ASSIGNED_COURSES, (table) => {
            table.increments("id", { primaryKey: true });
            table.integer("admin_id").unsigned().notNullable();
            table.foreign("admin_id").references("id").inTable(db_types_1.ETables.ADMIN);
            table.integer("course_id").unsigned().notNullable();
            table.foreign("course_id").references("id").inTable(db_types_1.ETables.COURSES);
            table.enu("stream", Object.values(enum_1.Stream)).notNullable();
            table.integer("session_id").unsigned().notNullable();
            table.foreign("session_id").references("id").inTable(db_types_1.ETables.ACADEMIC_SESSION);
            table.timestamps(true, true);
            table.unique(["course_id", "session_id"], { indexName: "unique_course_per_session_per_admin" });
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.dropTable(db_types_1.ETables.ASSIGNED_COURSES);
    });
}
exports.down = down;
