"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return knex.schema.alterTable(db_types_1.ETables.ASPIRANT, function (table) {
            table.specificType('adm_letter', 'LONGBLOB').alter();
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return knex.schema.alterTable(db_types_1.ETables.ASPIRANT, function (table) {
            table.binary('adm_letter').alter();
        });
    });
}
exports.down = down;
