"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.down = exports.up = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
function up(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.alterTable(db_types_1.ETables.ASPIRANT, (table) => {
            table.string("jamb_result_path");
            table.string("adm_letter_path");
            table.string("o_level_path");
            table.string("passport_path");
        })
            .alterTable(db_types_1.ETables.PROF_ASPIRANT, table => {
            table.string('certificate_path');
            table.string('passport_path');
        })
            .alterTable(db_types_1.ETables.ENROLLMENT, (table) => {
            table.string('certificate_path');
            table.string("o_level_path");
            table.string("jamb_result_path");
            table.string("adm_letter_path");
            table.string("passport_path");
            table.string("passport_mimetype");
        });
    });
}
exports.up = up;
function down(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        return yield knex.schema.alterTable(db_types_1.ETables.ASPIRANT, (table) => {
            table.dropColumns('passport_path', 'o_level_path', 'adm_letter_path', 'jamb_result_path');
        })
            .alterTable(db_types_1.ETables.PROF_ASPIRANT, (table) => {
            table.dropColumns('passport_path', 'certificate_path');
        })
            .alterTable(db_types_1.ETables.ENROLLMENT, (table) => {
            table.dropColumns('passport_mimetype', 'passport_path', 'adm_letter_path', 'jamb_result_path', 'o_level_path', 'certificate_path');
        });
    });
}
exports.down = down;
