"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.seed = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
const programmes = [
    {
        name: "NID",
        description: '',
        duration: '2 years',
        stream: enum_1.Stream.FULL,
        open_to_application: true
    },
    {
        name: "NID",
        description: '',
        duration: '3 years',
        stream: enum_1.Stream.PART,
        open_to_application: true
    },
    {
        name: "Professional",
        description: '',
        duration: '13 weeks',
        stream: enum_1.Stream.BASIC,
        open_to_application: true
    },
    {
        name: "Professional",
        description: '',
        duration: '13 weeks',
        stream: enum_1.Stream.ADVANCED,
        open_to_application: true
    }
];
function seed(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const new_programme = [];
        yield Promise.all(programmes.map((prog) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const pg = yield knex.select('*').from(db_types_1.ETables.PROGRAMME).where("stream", prog.stream).first();
            if (!pg) {
                new_programme.push(prog);
            }
            else {
                console.log(`Programme ${prog.name} already exists in the db`);
            }
        })));
        new_programme.length && (yield knex(db_types_1.ETables.PROGRAMME).insert(new_programme));
    });
}
exports.seed = seed;
;
// export async function seed(knex: Knex): Promise<void> {
//     await Promise.all(programmes.map(async prog => {
//         const new_programme = [];
//         const pg = await knex.select('*').from(ETables.PROGRAMME).where("stream", prog.stream).first();
//         !pg && new_programme.push(prog);
//         if(new_programme.length) {
//             await knex(ETables.PROGRAMME).insert(new_programme);
//         } else {
//             console.log(`Programme ${prog.name} already exists in the db`);
//         }
//     }))
// };
