"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.seed = void 0;
const tslib_1 = require("tslib");
const db_types_1 = require("../../types/db.types");
const enum_1 = require("../../types/enum");
const grades = [
    {
        mark_min: 75,
        mark_max: 100,
        letter_grade: 'A',
        weight: 4.00,
    },
    {
        mark_min: 70,
        mark_max: 74,
        letter_grade: 'AB',
        weight: 3.50,
    },
    {
        mark_min: 65,
        mark_max: 69,
        letter_grade: 'B',
        weight: 3.25,
    },
    {
        mark_min: 60,
        mark_max: 64,
        letter_grade: 'BC',
        weight: 3.00,
    },
    {
        mark_min: 55,
        mark_max: 59,
        letter_grade: 'C',
        weight: 2.75,
    },
    {
        mark_min: 50,
        mark_max: 54,
        letter_grade: 'CD',
        weight: 2.50,
    },
    {
        mark_min: 45,
        mark_max: 49,
        letter_grade: 'D',
        weight: 2.25,
    },
    {
        mark_min: 40,
        mark_max: 44,
        letter_grade: 'E',
        weight: 2.00,
    },
    {
        mark_min: 0,
        mark_max: 40,
        letter_grade: 'F',
        weight: 0.00,
    },
];
const cods = [
    {
        mark_min: 3.50,
        mark_max: 4.00,
        class: enum_1.COD.DISTINCTION,
    },
    {
        mark_min: 3.00,
        mark_max: 3.49,
        class: enum_1.COD.UPPER_CREDIT,
    },
    {
        mark_min: 2.50,
        mark_max: 2.99,
        class: enum_1.COD.LOWER_CREDIT,
    },
    {
        mark_min: 2.00,
        mark_max: 2.49,
        class: enum_1.COD.PASS,
    },
];
function seed(knex) {
    return tslib_1.__awaiter(this, void 0, void 0, function* () {
        const new_grade = [];
        yield Promise.all(grades.map((grd) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const existing_grade = yield knex.select('*').from(db_types_1.ETables.GRADE).where("letter_grade", grd.letter_grade).first();
            if (!existing_grade) {
                new_grade.push(grd);
            }
            else {
                console.log(`Grade ${grd.letter_grade} already exists in the db`);
            }
        })));
        const new_cod = [];
        yield Promise.all(cods.map((cod) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const existing_grade = yield knex.select('*').from(db_types_1.ETables.CGPA_GRADE).where("class", cod.class).first();
            if (!existing_grade) {
                new_cod.push(cod);
            }
            else {
                console.log(`Cumm ${cod.class} already exists in the db`);
            }
        })));
        new_grade.length && (yield knex(db_types_1.ETables.GRADE).insert(new_grade));
        new_cod.length && (yield knex(db_types_1.ETables.CGPA_GRADE).insert(new_cod));
    });
}
exports.seed = seed;
;
