"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const minimatch_1 = require("minimatch");
const api_response_1 = require("../../Utils/api_response");
const jwt_1 = require("../../Utils/jwt");
const authAdapter_1 = tslib_1.__importDefault(require("../../Database/adapters/authAdapter"));
const enum_1 = require("../../types/enum");
let AdminMiddleware = class AdminMiddleware {
    constructor(authAdapter) {
        this.authAdapter = authAdapter;
        this.permissionGuard = (permission) => (req, res, next) => {
            const { auth_user } = req.body;
            console.log(auth_user);
            console.log(enum_1.permission_divider);
            const user_permissions = auth_user.permissions.split(enum_1.permission_divider);
            // const user_permissions: Permisions[] = auth_user.permissions
            console.log(user_permissions);
            console.log(permission, 'required permission');
            let allowed = false;
            for (let up of user_permissions) {
                if ((0, minimatch_1.minimatch)(permission, up)) {
                    allowed = true;
                    break;
                }
                continue;
            }
            if (!allowed) {
                return (0, api_response_1.unAuthorized)(res, "", "You don't have permission to access this resource");
            }
            return next();
        };
        this.isAuth = (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { authorization } = req.headers;
            if (!authorization || !authorization.startsWith("Bearer")) {
                return (0, api_response_1.unAuthorized)(res, "Invalid token");
            }
            try {
                const token = authorization.split(" ")[1];
                const { id, email } = (0, jwt_1.decodeAdminToken)(token);
                const user = yield this.authAdapter.IsAdminExist(id, email);
                if (!user) {
                    return (0, api_response_1.unAuthorized)(res, "Invalid token");
                }
                req.body = Object.assign(Object.assign({}, req.body), { auth_user: Object.assign({}, user) });
                return next();
            }
            catch (error) {
                return (0, api_response_1.unAuthorized)(res, "Invalid token");
            }
        });
    }
};
AdminMiddleware = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [authAdapter_1.default])
], AdminMiddleware);
exports.default = AdminMiddleware;
