"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const express_1 = require("express");
const typedi_1 = require("typedi");
const Middleware_1 = require("../../Middleware");
const Fee_1 = tslib_1.__importDefault(require("../../Controller/Fee"));
const injector_1 = tslib_1.__importDefault(require("../../Middleware/injector"));
const Fee_2 = tslib_1.__importDefault(require("../../Validations/Fee"));
let FeeRouter = class FeeRouter {
    constructor(feeValidation, authMiddleware, injector, feeController) {
        this.feeValidation = feeValidation;
        this.authMiddleware = authMiddleware;
        this.injector = injector;
        this.feeController = feeController;
        this.path = '/fees';
        this.router = (0, express_1.Router)();
        this.initializeRoutes();
    }
    // need to handlle whn the student is coming foor the second year
    initializeRoutes() {
        this.router.get('/', this.authMiddleware.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidation.validateGetOutstandingFee, this.feeController.getOutstandingFee);
        this.router.get('/pay', this.authMiddleware.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeController.payOutstandingFee);
        this.router.post('/verify', this.authMiddleware.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidation.validateVerifyFeePayment, this.feeController.verifyOutstandingFeePayment);
        this.router.post('/transaction/webhook', this.injector.injectCurrentSessionAndDiet, this.feeController.paymentWebhook);
        // this.router.get('/professional/:programme_id/acceptance', this.injector.injectCurrentSessionAndDiet, this.feeValidation.validateGetAcceptanceFee, this.feeController.getProfAcceptanceFee);
        // this.router.post('/professional/:programme_id/acceptance/pay', this.injector.injectCurrentSessionAndDiet, this.feeValidation.validatePayProfAcceptanceFee, this.feeController.payProfAcceptanceFee);
        // this.router.post('/professional/:programme_id/acceptance/verify', this.injector.injectCurrentSession, this.feeValidation.validateProfAcceptanceFeePayment, this.feeController.verifyProfAcceptancePayment);
        // this.router.get('/putme', this.authMiddleware.isAspirantAuthenticated, this.injector.injectCurrentSession, this.feeController.getPutmeFee);
        // this.router.get('/putme/pay', this.authMiddleware.isAspirantAuthenticated, this.injector.injectCurrentSession, this.feeController.payPutmeFee);
        // this.router.post('/putme/verify', this.authMiddleware.isAspirantAuthenticated, this.feeValidation.validateVerifyPutmeFeePayment, this.feeController.verifyPutmePayment);
    }
};
FeeRouter = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [Fee_2.default,
        Middleware_1.AuthMiddleware,
        injector_1.default,
        Fee_1.default])
], FeeRouter);
exports.default = FeeRouter;
