"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const typedi_1 = require("typedi");
const express_1 = require("express");
const Student_1 = tslib_1.__importDefault(require("./Student"));
const Aspirant_1 = tslib_1.__importDefault(require("./Aspirant"));
const Fee_1 = tslib_1.__importDefault(require("./Fee"));
const Admin_1 = tslib_1.__importDefault(require("./Admin"));
const Course_1 = tslib_1.__importDefault(require("./Course"));
const path_1 = tslib_1.__importDefault(require("path"));
let Routerr = class Routerr {
    constructor(studentRouter, aspirantRouter, feeRouter, adminRouter, courseRouter) {
        this.studentRouter = studentRouter;
        this.aspirantRouter = aspirantRouter;
        this.feeRouter = feeRouter;
        this.adminRouter = adminRouter;
        this.courseRouter = courseRouter;
        this.initializeRoutes = () => {
            this.router.get('/test', (req, res) => res.status(200).json({ msg: 'Welcome to TMN_server' }));
            this.router.use(this.studentRouter.path, this.studentRouter.router);
            this.router.use(this.aspirantRouter.path, this.aspirantRouter.router);
            this.router.use(this.feeRouter.path, this.feeRouter.router);
            this.router.use(this.adminRouter.path, this.adminRouter.router);
            this.router.use(this.courseRouter.path, this.courseRouter.router);
            this.router.get('/download/:file_path', (req, res) => {
                const { file_path } = req.params;
                if (file_path === null || file_path === undefined || file_path === 'null')
                    throw new Error('Invalid file');
                const decodedFilePath = decodeURIComponent(file_path);
                const filePath = path_1.default.join(__dirname, '..', '..', '..', decodedFilePath);
                res.sendFile(filePath, err => {
                    if (err) {
                        console.error('Error sending file:', err);
                        res.status(500).send('Error downloading file');
                    }
                });
            });
        };
        this.path = '/api/v3';
        this.router = (0, express_1.Router)();
        this.initializeRoutes();
    }
};
Routerr = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [Student_1.default,
        Aspirant_1.default,
        Fee_1.default,
        Admin_1.default,
        Course_1.default])
], Routerr);
exports.default = Routerr;
