"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodeAdminToken = exports.generateAdminToken = exports.decodeToken = exports.generateToken = exports.decodeAspirantToken = exports.generateAspirantToken = exports.decodeProfAspirantToken = exports.generateProfAspirantToken = exports.decodeProfAspirantFormToken = exports.generateProfAspirantFormToken = void 0;
const tslib_1 = require("tslib");
const jsonwebtoken_1 = tslib_1.__importDefault(require("jsonwebtoken"));
const generateProfAspirantFormToken = (data) => {
    return jsonwebtoken_1.default.sign(Object.assign({}, data), process.env.JWT_SECRET);
};
exports.generateProfAspirantFormToken = generateProfAspirantFormToken;
const decodeProfAspirantFormToken = (token) => {
    return jsonwebtoken_1.default.decode(token);
};
exports.decodeProfAspirantFormToken = decodeProfAspirantFormToken;
const generateProfAspirantToken = (data) => {
    return jsonwebtoken_1.default.sign(data, process.env.JWT_SECRET, { expiresIn: "1d" });
};
exports.generateProfAspirantToken = generateProfAspirantToken;
const decodeProfAspirantToken = (token) => {
    return jsonwebtoken_1.default.decode(token);
};
exports.decodeProfAspirantToken = decodeProfAspirantToken;
const generateAspirantToken = (data) => {
    return jsonwebtoken_1.default.sign(Object.assign({}, data), process.env.JWT_SECRET, { expiresIn: "1d" });
};
exports.generateAspirantToken = generateAspirantToken;
const decodeAspirantToken = (token) => {
    return jsonwebtoken_1.default.decode(token);
};
exports.decodeAspirantToken = decodeAspirantToken;
const generateToken = (data) => {
    return jsonwebtoken_1.default.sign(data, process.env.JWT_SECRET, { expiresIn: "1d" });
};
exports.generateToken = generateToken;
const decodeToken = (token) => {
    return jsonwebtoken_1.default.decode(token);
};
exports.decodeToken = decodeToken;
const generateAdminToken = (data) => {
    return jsonwebtoken_1.default.sign(data, process.env.JWT_SECRET, { expiresIn: '1d' });
};
exports.generateAdminToken = generateAdminToken;
const decodeAdminToken = (token) => {
    return jsonwebtoken_1.default.decode(token);
};
exports.decodeAdminToken = decodeAdminToken;
// export const encodeOTP = (code: string, email: string): string => {
//   return jwt.sign({ code, email }, process.env.JWT_SECRET!, { expiresIn: "15m" })
// }
// export const decodeOTP = (token: string): { email: string, code: string } => {
//   return jwt.decode(token) as { email: string, code: string };
// }
// export const decodeStaffToken = (token: string): { staff_no: string, id: number, role: Role } => {
//   return jwt.decode(token) as { staff_no: string, id: number, role: Role };
// }
// const adm_no = await generateRegNo();
//             console.log(adm_no, 'new_adm_no');
