"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateContent = void 0;
const fs_1 = require("fs");
const path_1 = require("path");
const generateContent = (fileName, replacements) => {
    const filePath = (0, path_1.join)(__dirname, fileName);
    let content = (0, fs_1.readFileSync)(filePath, 'utf8');
    Object.keys(replacements).forEach((key) => {
        const regex = new RegExp(`{{${key}}}`, 'g');
        content = content.replace(regex, replacements[key]);
    });
    return content;
};
exports.generateContent = generateContent;
