"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const __1 = tslib_1.__importDefault(require(".."));
const typedi_1 = require("typedi");
const enum_1 = require("../../types/enum");
const courseAdapter_1 = require("../../Database/adapters/courseAdapter");
const feeAdapter_1 = require("../../Database/adapters/feeAdapter");
const studentAdapter_1 = require("../../Database/adapters/studentAdapter");
let CourseValidation = class CourseValidation extends __1.default {
    constructor(courseValAdapter, feeValAdapter, studentValAdapter) {
        super();
        this.courseValAdapter = courseValAdapter;
        this.feeValAdapter = feeValAdapter;
        this.studentValAdapter = studentValAdapter;
        this.validateGetCourse = this.validate({
            stream: {
                in: ['params'],
                isIn: { options: [Object.values(enum_1.Stream)] },
            }
        });
        this.validateCourseRegistration = this.validate({
            ids: {
                in: 'body',
                isArray: { options: { min: 1 } },
                notEmpty: true,
                isInt: true,
                custom: {
                    options: (ids, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const { auth_user, session } = req.body;
                        if (new Set(ids).size !== ids.length)
                            throw new Error('The courses must be unique');
                        const student = yield this.studentValAdapter.DBGetStudent(auth_user.matric_no);
                        // if (student.stream !== Stream.STANDARD) {
                        if (Object.values(enum_1.PROF_Stream).includes(student.stream)) {
                            const courses = yield this.courseValAdapter.DBGetAllCourses(student.stream);
                            const picked_all = courses.every(course => ids.some((id) => course.id === id));
                            const sameLength = courses.length === ids.length;
                            if (!(picked_all && sameLength))
                                throw new Error('You are required to select all the courses available for your programme');
                            const registered = yield this.courseValAdapter.DBHasCourseForCurrentSession(ids[0], auth_user.id, session.id);
                            if (registered)
                                throw new Error(`Courses already registered!. You can't register the same course in a session`);
                        }
                        else {
                            // check if courses are valid
                            for (let id of ids) {
                                const exist = yield this.courseValAdapter.DBGetCourseById(id);
                                if (!exist)
                                    throw new Error(`One of the course is invalid`);
                                //check if registered before in the current session
                                const registered = yield this.courseValAdapter.DBHasCourseForCurrentSession(id, auth_user.id, session.id);
                                if (registered)
                                    throw new Error(`Course ${exist.code} already registered!. You can't register the same course in a session`);
                            }
                        }
                    })
                }
            }
        });
        this.validateDropCourse = this.validate({
            id: {
                in: 'params',
                isInt: true,
                custom: {
                    options: (id, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const { auth_user, session } = req.body;
                        const exist = yield this.courseValAdapter.DBGetCourseById(id);
                        if (!exist)
                            throw new Error('Invalid course');
                        console.log(id);
                        const hasCourse = yield this.courseValAdapter.DBHasCourseForCurrentSession(id, auth_user.id, session.id);
                        console.log(hasCourse);
                        if (!hasCourse)
                            throw new Error('Yet to registered for the specified course');
                    })
                }
            }
        });
    }
};
CourseValidation = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [courseAdapter_1.CourseValidatorAdapter,
        feeAdapter_1.FeeValidatorAdapter,
        studentAdapter_1.StudentValidatorAdapter])
], CourseValidation);
exports.default = CourseValidation;
