"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const __1 = tslib_1.__importDefault(require(".."));
const typedi_1 = require("typedi");
const feeAdapter_1 = require("../../Database/adapters/feeAdapter");
const api_response_1 = require("../../Utils/api_response");
const pay_refAdapter_1 = require("../../Database/adapters/pay_refAdapter");
const aspirantAdapter_1 = require("../../Database/adapters/aspirantAdapter");
const enum_1 = require("../../types/enum");
let FeeValidation = class FeeValidation extends __1.default {
    constructor(aspirantValAdapter, feevalAdapter, pay_refValAdapter) {
        super();
        this.aspirantValAdapter = aspirantValAdapter;
        this.feevalAdapter = feevalAdapter;
        this.pay_refValAdapter = pay_refValAdapter;
        this.validateFormPayment = this.validate({
            stream: {
                in: 'params',
                isIn: { options: [Object.values(enum_1.PROF_Stream)] }
            },
            split: {
                in: 'query',
                isBoolean: true,
                toBoolean: true,
                custom: {
                    options: (split) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const allowed = yield this.feevalAdapter.DBIsFeeSplittable(enum_1.Fee_Type.FORM, enum_1.Category.PROFESSIONAL);
                        if (split && !allowed)
                            throw new Error('Sorry this fee is can\'t be splitted');
                    })
                }
            },
            email: {
                in: ["body"],
                isEmail: true,
                toLowerCase: true,
                custom: {
                    options: (email) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const aspirant = yield this.aspirantValAdapter.DBCheckApplicationEmail(email);
                        if (aspirant)
                            throw new Error("Email already exists!");
                    })
                }
            },
            first_name: {
                in: ["body"],
                isString: true,
                notEmpty: true,
            },
            last_name: {
                in: ["body"],
                isString: true,
                notEmpty: true,
            },
            middle_name: {
                in: ["body"],
                isString: true,
                optional: true
            },
        });
        this.validateGetProfAcceptanceFee = this.validate({
            stream: {
                in: ['params'],
                isIn: { options: [Object.values(enum_1.Stream)] },
                custom: {
                    options: (stream, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        // check if paid for appllication form
                        const { auth_user } = req.body;
                        const aspirant = yield this.aspirantValAdapter.DBGetAcceptedProfAspirant(auth_user.email);
                        if (!aspirant)
                            throw new Error('You are not eligible too pay for this fee at the moment');
                    })
                }
            }
        });
        // NID
        this.validateGetAcceptanceFee = (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                const aspirant = yield this.aspirantValAdapter.DBGetAcceptedAspirant(auth_user.jamb_reg);
                if (!aspirant)
                    throw new Error(`You can\'t perform this action. Kindlyy wait till you're given admission`);
                return next();
            }
            catch (error) {
                console.log(error);
                return (0, api_response_1.badRequest)(res, null, "Something went wrong");
            }
        });
        // BOTH
        this.validateFeeVerification = this.validate({
            reference: {
                in: 'query',
                isString: true,
                custom: {
                    options: (reference, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const used = yield this.pay_refValAdapter.DBReferenceUsed(reference);
                        console.log(used);
                        if (used)
                            throw new Error('Invalid payment, rf');
                    })
                }
            },
            fee_id: {
                in: 'body',
                isInt: true,
                custom: {
                    options: (fee_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const fee = yield this.feevalAdapter.DBFeeExist(fee_id);
                        if (!fee)
                            throw new Error('Invalid fee');
                    })
                }
            }
        });
        this.validateAcceptancePayment = (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                const { stream } = req.params;
                const { split } = req.query;
                if (stream && !(Object.values(enum_1.Stream).includes(stream)))
                    throw new Error('Invalid stream');
                // let aspirant;
                // if (stream) {
                //   aspirant = await this.aspirantValAdapter.DBGetAcceptedProfAspirant(auth_user.email);
                // } else {
                //   aspirant = await this.aspirantValAdapter.DBGetAcceptedAspirant(auth_user.jamb_reg);
                // }
                let aspirant = yield this.aspirantValAdapter.DBGetAcceptedProfAspirant(req.body.auth_user.email);
                if (!aspirant)
                    aspirant = yield this.aspirantValAdapter.DBGetAcceptedAspirant(req.body.auth_user.jamb_reg);
                if (!aspirant)
                    throw new Error('You are not eligible to pay the acceptance fee');
                if (aspirant && aspirant.paid)
                    return (0, api_response_1.badRequest)(res, null, "You already paid the acceptance fee, proceed to pay the school fee if you're yet to do so");
                // const category = auth_user.stream ? Category.PROFESSIONAL : Category.STANDARD
                const category = (auth_user.stream === enum_1.PROF_Stream.BASIC || auth_user.stream === enum_1.PROF_Stream.ADVANCED) ? enum_1.Category.PROFESSIONAL : auth_user.stream === enum_1.NID_Stream.FULL ? enum_1.Category.FULL : enum_1.Category.PART;
                const allowed = yield this.feevalAdapter.DBIsFeeSplittable(enum_1.Fee_Type.ACCEPTANCE, category);
                // if (split as boolean && !allowed) throw new Error('Sorry this fee can\'t be splitted');
                const spt = split === true;
                if (spt && !allowed)
                    throw new Error('Sorry this fee can\'t be splitted');
                return next();
            }
            catch (error) {
                console.log(error);
                return (0, api_response_1.badRequest)(res, null, "Something went wrong");
            }
        });
        this.validateGetSchoolFee = this.validate({
            stream: {
                in: ['params'],
                isIn: { options: [Object.values(enum_1.Stream)] },
                custom: {
                    options: (stream) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        // check if paid for appllication form
                    })
                }
            },
            split: {
                in: 'query',
                isBoolean: true,
                toBoolean: true,
                custom: {
                    options: (split, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        var _a;
                        // const strm = req.params?.stream || Stream.STANDARD
                        const allowed = yield this.feevalAdapter.DBIsFeeSplittable(enum_1.Fee_Type.TUITION, (_a = req.params) === null || _a === void 0 ? void 0 : _a.stream);
                        if (split && !allowed)
                            throw new Error('Sorry this fee is can\'t be splitted');
                    })
                }
            },
        });
        this.validatePaySchoolFeeAndIDCard = this.validate({
            stream: {
                in: 'params',
                isIn: { options: [Object.values(enum_1.Category)] },
                optional: true
            },
            split: {
                in: ['query'],
                isBoolean: true,
                toBoolean: true,
                custom: {
                    options: (split, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        // check if paid for acceptance fee
                        // let aspi;
                        // if (req.params?.stream) {
                        //   aspi = await this.aspirantValAdapter.DBGetAcceptedProfAspirant(req.body.auth_user.email)
                        // } else {
                        //   aspi = await this.aspirantValAdapter.DBGetAcceptedAspirant(req.body.auth_user.jamb_reg)
                        // }
                        let aspi = yield this.aspirantValAdapter.DBGetAcceptedProfAspirant(req.body.auth_user.email);
                        if (!aspi)
                            aspi = yield this.aspirantValAdapter.DBGetAcceptedAspirant(req.body.auth_user.jamb_reg);
                        if (!aspi.paid)
                            throw new Error('You can only pay this fee after you clearing the acceptance fee or payng the both together');
                        // const strm = req.params?.stream || Stream.STANDARD
                        const allowed = yield this.feevalAdapter.DBIsFeeSplittable(enum_1.Fee_Type.TUITION, req.body.auth_user.stream);
                        if (split && !allowed)
                            throw new Error('Sorry this fee is can\'t be splitted');
                    })
                }
            }
        });
        this.validateSchoolFeeAndIDCardVerification = this.validate({
            reference: {
                in: 'query',
                isString: true,
                custom: {
                    options: (reference, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const used = yield this.pay_refValAdapter.DBReferenceUsed(reference);
                        console.log(used);
                        if (used)
                            throw new Error('Invalid payment, rf');
                    })
                }
            },
            fee_ids: {
                in: 'body',
                // isArray: true,
                // notEmpty: true,
                // isLength: { options: { min: 2, max: 2 } },
                isString: true,
                custom: {
                    options: (fee_ids) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        // '1,5'
                        fee_ids.split(',').map((id) => +id).map((fee_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                            const fee = yield this.feevalAdapter.DBFeeExist(fee_id);
                            if (!fee)
                                throw new Error('Invalid fee');
                        }));
                        // fee_ids.map(async (fee_id: number) => {
                        //   const fee = await this.feevalAdapter.DBFeeExist(fee_id);
                        //   if (!fee) throw new Error('Invalid fee');
                        // })
                    })
                }
            }
        });
        this.validatePayAcceptanceSchoolFeeAndIDCard = this.validate({
            stream: {
                in: 'params',
                isIn: { options: [Object.values(enum_1.Category)] },
                optional: true
            },
            split: {
                in: ['query'],
                isBoolean: true,
                toBoolean: true,
                custom: {
                    options: (split, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        // let aspirant;
                        // if (req.params?.stream) {
                        //   aspirant = await this.aspirantValAdapter.DBGetAcceptedProfAspirant(req.body.auth_user.email);
                        // } else {
                        //   aspirant = await this.aspirantValAdapter.DBGetAcceptedAspirant(req.body.auth_user.jamb_reg);
                        // }
                        let aspirant = yield this.aspirantValAdapter.DBGetAcceptedProfAspirant(req.body.auth_user.email);
                        if (!aspirant)
                            aspirant = yield this.aspirantValAdapter.DBGetAcceptedAspirant(req.body.auth_user.jamb_reg);
                        if (!aspirant)
                            throw new Error('You are not eligible to pay the acceptance fee');
                        if (aspirant && aspirant.paid)
                            throw new Error("You already paid the acceptance fee, proceed to pay the school fee if you're yet to do so");
                        // const strm = req.params?.stream || Stream.STANDARD
                        const allowed = yield this.feevalAdapter.DBIsFeeSplittable(enum_1.Fee_Type.TUITION, req.body.auth_user.stream);
                        if (split && !allowed)
                            throw new Error('Sorry this fee is can\'t be splitted');
                    })
                }
            }
        });
        this.validateAcceptanceSchoolFeeAndIDCardVerification = this.validate({
            reference: {
                in: 'query',
                isString: true,
                custom: {
                    options: (reference, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const used = yield this.pay_refValAdapter.DBReferenceUsed(reference);
                        console.log(used);
                        if (used)
                            throw new Error('Invalid payment, rf');
                    })
                }
            },
            fee_ids: {
                in: 'body',
                isString: true,
                custom: {
                    options: (fee_ids) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        fee_ids.split(',').map((id) => +id).map((fee_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                            const fee = yield this.feevalAdapter.DBFeeExist(fee_id);
                            if (!fee)
                                throw new Error('Invalid fee');
                        }));
                    })
                }
            }
        });
        this.validateSchoolFeePayment = (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user } = req.body;
                // const checkOutstanding = 
                return next();
            }
            catch (error) {
                return (0, api_response_1.badRequest)(res, null, "Something went wrong");
            }
        });
        // STUDENTTT
        this.validateGetOutstandingFee = this.validate({
        // returning: {
        //   in: 'query',
        //   isBoolean: true,
        //   toBoolean: true,
        // },
        });
        this.validateVerifyFeePayment = this.validate({
            reference: {
                in: 'query',
                isString: true,
                custom: {
                    options: (reference) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const used = yield this.pay_refValAdapter.DBReferenceUsed(reference);
                        if (used)
                            throw new Error('Invalid payment, rf');
                    })
                }
            },
            fee_ids: {
                in: 'body',
                isString: true,
                custom: {
                    options: (fee_ids) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        fee_ids.split(',').map((id) => +id).map((fee_id) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                            const fee = yield this.feevalAdapter.DBFeeExist(fee_id);
                            if (!fee)
                                throw new Error('Invalid fee');
                        }));
                    })
                }
            },
            residual: {
                in: ['query'],
                isBoolean: true,
                toBoolean: true
            }
        });
    }
};
FeeValidation = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [aspirantAdapter_1.AspirantValidatorAdapter,
        feeAdapter_1.FeeValidatorAdapter,
        pay_refAdapter_1.Pay_refValidatorAdapter])
], FeeValidation);
exports.default = FeeValidation;
