"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const bcryptjs_1 = tslib_1.__importDefault(require("bcryptjs"));
const __1 = tslib_1.__importDefault(require(".."));
const studentAdapter_1 = require("../../Database/adapters/studentAdapter");
const typedi_1 = require("typedi");
// import { decodeOTP } from '../../Utils/jwt';
const enum_1 = require("../../types/enum");
const api_response_1 = require("../../Utils/api_response");
const feeAdapter_1 = require("../../Database/adapters/feeAdapter");
let StudentValidation = class StudentValidation extends __1.default {
    constructor(studentValAdapter, feeValAdapter) {
        super();
        this.studentValAdapter = studentValAdapter;
        this.feeValAdapter = feeValAdapter;
        this.loginValidator = this.validate({
            matric_no: {
                in: ["body"],
                isString: true,
                isLength: { options: { min: 4 } }
            },
            password: {
                in: ["body"],
                isString: true,
                notEmpty: true,
                custom: {
                    options: (password, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        const { matric_no } = req.body;
                        const student = yield this.studentValAdapter.DBGetStudent(matric_no);
                        if (!student || !bcryptjs_1.default.compareSync(password, student.password))
                            throw new Error("Invalid credentials!");
                    })
                }
            }
        });
        this.validateGetResult = this.validate({
            level: {
                in: 'query',
                isString: true,
                isIn: { options: Object.values(enum_1.Level) },
                optional: true
            },
            // current_semester: {
            //   in: 'query',
            //   isBoolean: true,
            //   toBoolean: true
            // },
            semester: {
                in: 'query',
                isString: true,
                isIn: { options: Object.values(enum_1.Semester) },
                optional: true,
                custom: {
                    options: (semester, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        // // if (!req.query?.current_semester && !semester) throw new Error("Semester can't be undefined when it's not for the current semester")
                        // // else if (req.query?.current_semester && semester) throw new Error('Semester canoot be defined when current semester is enabled')
                        // // else {
                        //   const valid_session = await this.studentValAdapter.DBIsValidSession(+req.query?.session_id);
                        //   if (!valid_session) throw new Error('Invalid session')
                        // // }
                    })
                }
            },
            session_id: {
                in: ['query'],
                isInt: true,
                custom: {
                    options: (session_id, { req }) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                        var _a, _b, _c, _d;
                        if (!((_a = req.query) === null || _a === void 0 ? void 0 : _a.level) && ((_b = req.query) === null || _b === void 0 ? void 0 : _b.semester)) {
                            throw new Error("The evel can't be undeifned hen the semester is defined");
                        }
                        else if (!((_c = req.query) === null || _c === void 0 ? void 0 : _c.level) && +session_id !== 0) {
                            throw new Error('Session_id has to be zero if level is undefined');
                        }
                        else if (session_id && ((_d = req.query) === null || _d === void 0 ? void 0 : _d.level)) {
                            const valid_session = yield this.studentValAdapter.DBIsValidSession(session_id);
                            if (!valid_session)
                                throw new Error('Invalid session');
                        }
                    })
                }
            },
            diet: {
                in: 'query',
                isInt: true,
                optional: true
            }
        });
        // public validateGetExamSlip = this.validate({})
        this.validateGetExamSlip = (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, session } = req.body;
                const outstandingFee = yield this.feeValAdapter.DBCheckOutstandingFee(auth_user.id, session.id, auth_user.stream, true);
                if (outstandingFee)
                    return (0, api_response_1.badRequest)(res, null, 'You need to clear any outstanding fee before you can access this resource');
                return next();
            }
            catch (error) {
                return (0, api_response_1.badRequest)(res, null, "Something went wrong");
            }
        });
        this.validateGetInternLetter = (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            try {
                const { auth_user, session } = req.body;
                if (auth_user.stream !== 'standard')
                    return (0, api_response_1.badRequest)(res, null, 'THis is only available for advance certificate programme');
                const outstandingFee = yield this.feeValAdapter.DBCheckOutstandingFee(auth_user.id, session.id, auth_user.stream, true);
                if (outstandingFee)
                    return (0, api_response_1.badRequest)(res, null, 'You need to clear any outstanding fee before you can access this resource');
                return next();
            }
            catch (error) {
                return (0, api_response_1.badRequest)(res, null, "Something went wrong");
            }
        });
    }
};
StudentValidation = tslib_1.__decorate([
    (0, typedi_1.Service)(),
    tslib_1.__metadata("design:paramtypes", [studentAdapter_1.StudentValidatorAdapter,
        feeAdapter_1.FeeValidatorAdapter])
], StudentValidation);
exports.default = StudentValidation;
