"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const api_response_1 = require("../Utils/api_response");
const express_validator_1 = require("express-validator");
const multer_1 = require("../Utils/multer");
class Validator {
    constructor() {
        this.validate = (schema) => (req, res, next) => tslib_1.__awaiter(this, void 0, void 0, function* () {
            yield Promise.all((0, express_validator_1.checkSchema)(schema).map(validation => validation.run(req)));
            const errors = (0, express_validator_1.validationResult)(req);
            if (errors.isEmpty()) {
                return next();
            }
            console.log(req.uploadedFiles, 'req.uploadedFiles');
            if (req.uploadedFiles && req.uploadedFiles.length > 0) {
                (0, multer_1.deleteFiles)(req.uploadedFiles);
            }
            // const errs: ValidationError[] = errors.array() as any
            const errs = errors.array();
            const message = errs[0].msg == 'Invalid value' ? `${errs[0].msg} at ${errs[0].path}` : errs[0].msg;
            return (0, api_response_1.badRequest)(res, errs, message);
        });
    }
}
exports.default = Validator;
