import { Request, Response } from "express";
import { Inject, Service } from "typedi";
import IndexController from "..";
import { success, successAction } from "../../Utils/api_response";
import CourseAdapter from "../../Database/adapters/courseAdapter";
import { Stream } from "../../types/enum";
import { generateCFPDF } from "../../Utils/pdf/jspdf";
// import { generatePDF } from "../../Utils/pdf/PDFkit";

@Service()
class CourseController extends IndexController {
    constructor(
        private readonly courseAdapter: CourseAdapter
    ) {
        super()
    }

    public getAllCourses = async (req: Request, res: Response) => {
        try {
            const { stream } = req.params as { stream: Stream }

            const courses = await this.courseAdapter.DBGetAllCourses(stream);
            console.log(courses)
            return success(res, courses);
        } catch (error) {
            return this.catchError(error, res);
        }
    }

    public getMyCourses = async (req: Request, res: Response) => {
        try {
            const { auth_user } = req.body;
            const courses = await this.courseAdapter.DBGetMyCourses(auth_user.id);

            return success(res, courses);
        } catch (error) {
            return this.catchError(error, res);
        }
    }

    public register = async (req: Request, res: Response) => {
        try {
            const { auth_user, ids, session } = req.body;

            await this.courseAdapter.DBRegister(auth_user.id, ids, session.id, auth_user.level);

            return successAction(res, 'Registration successful');
        } catch (error) {
            return this.catchError(error, res);
        }
    }

    public generateCourseForm = async (req: Request, res: Response) => {
        try {
            const { auth_user, session } = req.body;

            console.log('in test mode');
            const courses = await this.courseAdapter.DBGetMyCourses(auth_user.id);
            // const columns = ["Course Code", "Title", "Units", "Semester", "Course Status"];

            // const overall = [];
            // for (let d of courses) {
            //     const current = []
            //     // console.log(d);
            //     for (let col of columns) {
            //         // console.log(col, 'col')
            //         for (let key in d) {
            //             // console.log(key, 'key')
            //             if (col.toLowerCase().includes(key))
            //                 current.push(d[key])
            //         }
            //     }
            //     // console.log(current);
            //     overall.push(current)
            // }

            // console.log(overall)

            const columnKeyMapping: { [key: string]: string } = {
                "Course Code": "code",
                "Title": "title",
                "Units": "unit",
                "Semester": "semester",
                "Course Status": "type"
            };

            const overall = courses.map(course => {
                const current = [];

                for(let key of Object.keys(columnKeyMapping)) {
                    const colKey = columnKeyMapping[key];

                    if(course.hasOwnProperty(colKey)) {
                        current.push(course[colKey])
                    } else {
                        current.push('N/A');
                    }
                }

                return current;
            });

            generateCFPDF(res, auth_user, overall);
        } catch (error) {
            return this.catchError(error, res);
        }
    }

    public dropCourse = async (req: Request, res: Response) => {
        try {
            const { auth_user, session } = req.body;
            const { id } = req.params;

            await this.courseAdapter.DBDropCourse(auth_user.id, +id, session.id);

            return successAction(res, 'Successfully dropped course');
        } catch (error) {
            return this.catchError(error, res);
        }
    }
};

export default CourseController;