import { Service } from "typedi";
import knex, { BaseAdapter } from ".";
import { ETables } from "../../types/db.types";
import { NID_Stream, PROF_Stream } from "../../types/enum";

@Service()
class AuthAdapter extends BaseAdapter {
    constructor() {
        super()
    }

    public GetProfAspirant = async (email: string, stream: PROF_Stream) => {
        try {
            const aspirant = await knex.select([
                "aspi.id as id",
                "aspi.first_name as first_name",
                "aspi.last_name as last_name",
                "aspi.middle_name as middle_name",
                "aspi.email as email",
                "aspi.DOB as DOB",
                "aspi.gender as gender",
                "aspi.phone as phone",
                "aspi.qualification as qualification",
                "aspi.workplace as workplace",
                "aspi.years_of_exp as years_of_exp",
                "aspi.certificate as certificate",
                // "aspi.year as year",
                "aspi.paid as paid",
                "aspi.status as status",
                'prog.id as programme_id',
                'prog.name as name',
                'prog.description as description',
                'prog.duration as duration',
                'prog.stream as stream',
                'prog.open_to_application as open_to_application',
                'diet.number as diet',
                'diet.year as diet_year',
                'diet.is_current as is_current',
                'diet.session_id as session_id',
            ]).from({ aspi: ETables.PROF_ASPIRANT })
            .join({ prog: ETables.PROGRAMME }, 'prog.id', 'aspi.programme_id')
            .join({ diet: ETables.DIET }, 'diet.id', 'aspi.diet_id')
            .where("email", email).andWhere('prog.stream', stream).first();

            return aspirant;
        } catch (error) {
            return this.catchError(error);
        }
    }

    public DBGetAspirant = async (id: number, stream?: NID_Stream, jamb_reg?: string) => {
        try {
            const aspirant = await knex.select([
                "aspi.*",
                'prog.id as programme_id',
                'prog.name as name',
                'prog.description as description',
                'prog.duration as duration',
                'prog.stream as stream',
                'prog.open_to_application as open_to_application',
            ])
            .from({ aspi: ETables.ASPIRANT })
            .join({ prog: ETables.PROGRAMME }, 'prog.id', 'aspi.programme_id')
            .where('aspi.id', id)
            // .andWhere('aspi.email', email)
            // .andWhere("jamb_reg", jamb_reg)
            .modify((queryBuilder) => {
                if (stream !== undefined) {
                    queryBuilder.where('prog.stream', stream);
                }
                if (jamb_reg !== undefined) {
                    queryBuilder.where('aspi.jamb_reg', jamb_reg);
                }
            })
            .first();


console.log(aspirant)
            aspirant && delete aspirant.password;

            return aspirant;
        } catch (error) {
            return this.catchError(error);
        }
    }

    // public DBGetAspirant = async (id: number, jamb_reg: string) => {
    //     try {
    //         const aspirant = await knex.raw(
    //             `SELECT *, -password AS password FROM ?? WHERE id = ? AND jamb_reg = ? LIMIT 1`,
    //             [ETables.ASPIRANT, id, jamb_reg]
    //         );
    
    //         return aspirant.rows[0];
    //     } catch (error) {
    //         return this.catchError(error);
    //     }
    // };
    
    public GetStudent = async (id: number, matric_no: string) => {
        try {
            const student = await knex.select([
                "first_name",
                "last_name",
                "email",
                "id",
                'adm_no',
                "matric_no",
                'stream',
                'level',
                'paid'
            ]).from(ETables.STUDENT).where("id", id).andWhere("matric_no", matric_no).first();

            return student;
        } catch (error) {
            return this.catchError(error)
        }
    }

    public IsAdminExist = async (id: number, email: string) => {
        try {
            const admin = await knex.select(["a.*", "r.permissions as permissions"]).from({ a: ETables.ADMIN }).leftJoin({ r: ETables.ADMIN_ROLE }, "r.id", "a.role_id").where("a.id", id).andWhere("a.email", email).first();

            return admin;
        } catch (error) {
            return this.catchError(error)
        }
    }
}

export default AuthAdapter;