import { Service } from "typedi";
import knex, { BaseAdapter } from ".";
import { ETables } from "../../types/db.types";

@Service()
class Pay_refAdapter extends BaseAdapter {
    constructor() {
        super()
    }

    public DBSavePaymentRef = async (email: string, reference: string, description: object) => {
        try {
            await knex(ETables.PAY_REF).insert({ email, reference, description });
        } catch (error) {
            return this.catchError(error);
        }
    }
}

@Service()
export class Pay_refValidatorAdapter extends BaseAdapter {
    constructor() {
        super();
    }

    public DBReferenceUsed = async (reference: string) => {
        try {
            const used = await knex.select('*').from(ETables.PAY_REF).where("reference", reference).first();

            return !!used;
        } catch (error) {
            return this.catchError(error);
        }
    }
}

export default Pay_refAdapter;
