import { config } from 'dotenv';

const env = process.env.NODE_ENV || 'development';

const envFilePath = env === 'production'
  ? './../../../.env'
  : './../../.env';

config({ path: envFilePath })

const knexConfig = {
  client: 'mysql2',
  connection: process.env.DATABASE_URL 
    ??
  {
    user: process.env.DB_USER,
    password: process.env.DB_PASS,
    database: process.env.DB_NAME,
    host: process.env.DB_HOST,
    // server: process.env.DB_HOST, 
    port: process.env.DB_PORT
  },
  pool: {
    min: 2,
    max: 10
  },
  migrations: {
    tableName: 'knex_migrations',
    directory: 'migrations',
    extensions: 'ts'
  },
  seeds: {
    directory: 'seeds',
    extensions: 'ts',
    order: ['seed_session.ts', 'seed_programme.ts', 'seed_fee.ts']
  },
  timezone: 'UTC',
};

export default knexConfig;
