import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Stream } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.PROGRAMME, (table) => {
        table.increments("id", { primaryKey: true });
        table.string("name", 255).notNullable();
        table.text("description", "longtext");
        // table.bigInteger("duration").notNullable();
        table.string("duration").notNullable();
        table.enum("stream", Object.values(Stream)).notNullable().unique();
        table.boolean('open_to_application').notNullable().defaultTo(true);
        table.timestamps(true, true);
    })
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.PROGRAMME);
}
