import { Knex } from "knex";
import { ETables } from "../../types/db.types";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.DIET, (table) => {
        table.increments("id", { primaryKey: true });
        table.integer("number").notNullable();
        table.integer("year").notNullable()
        table.boolean('is_current').notNullable().defaultTo(false);
        table.integer("session_id").unsigned()
        table.foreign("session_id").references("id").inTable(ETables.ACADEMIC_SESSION);
        table.timestamps(true, true);

        table.unique(["number", "year", "session_id"], { indexName: "unique_DIET_year_session" });
    })
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.DIET);
}
