import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Gender, Status } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.ASPIRANT, (table) => {
        table.increments("id", { primaryKey: true });
        table.string("first_name", 255).notNullable();
        table.string("last_name", 255).notNullable();
        table.string("middle_name", 255);
        table.string("email").unique().notNullable();
        table.date('DOB');
        table.enum("gender", Object.values(Gender)).notNullable()
        table.string("phone").notNullable();
        table.string('jamb_reg');
        table.string("password").notNullable();
        table.string('state_of_origin');
        table.string('lga');
        table.string('address');
        table.json("manual_o_level");
        table.binary("o_level");
        table.string('o_level_mimetype');
        table.binary("jamb_result");
        table.string('jamb_result_mimetype');
        table.float('score').notNullable().defaultTo(0.00);
        table.binary("adm_letter");
        table.string('adm_letter_mimetype');
        table.boolean('paid').notNullable().defaultTo(false);
        table.enum("status", Object.values(Status)).notNullable().defaultTo(Status.PENDING);
        table.specificType("passport", 'LONGBLOB');
        table.string('passport_mimetype');
        table.integer("diet_id").unsigned()
        table.foreign("diet_id").references("id").inTable(ETables.DIET);
        table.integer("programme_id").unsigned()
        table.foreign("programme_id").references("id").inTable(ETables.PROGRAMME);
        table.integer("session_id").unsigned()
        table.foreign("session_id").references("id").inTable(ETables.ACADEMIC_SESSION);
        table.timestamps(true, true);

    })
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.ASPIRANT);
}
