import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Stream } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.ENROLLMENT, (table) => {
        table.increments("id", { primaryKey: true });
        table.string('jamb_reg');
        table.date('enrollment_date').notNullable();
        table.date('completion_date').notNullable();
        table.string("qualification");
        table.string("workplace");
        table.integer('years_of_exp');
        table.binary("certificate");
        table.string('certificate_mimetype');
        table.binary("o_level");
        table.string('o_level_mimetype');
        table.binary("jamb_result");
        table.string('jamb_result_mimetype');
        table.binary("adm_letter");
        table.string('adm_letter_mimetype');
        table.enu('stream', Object.values(Stream)).notNullable();
        table.integer("entry_session").unsigned()
        table.foreign("entry_session").references("id").inTable(ETables.ACADEMIC_SESSION);
        table.integer("student_id").unsigned()
        table.foreign("student_id").references("id").inTable(ETables.STUDENT);
        table.integer("programme_id").unsigned()
        table.foreign("programme_id").references("id").inTable(ETables.PROGRAMME);
        table.integer("diet_id").unsigned();
        table.foreign("diet_id").references("id").inTable(ETables.DIET);
        table.integer("session_id").unsigned()
        table.foreign("session_id").references("id").inTable(ETables.ACADEMIC_SESSION);
        table.timestamps(true, true);
    })
    // .raw(`
    //   ALTER TABLE ${ETables.ENROLLMENT}
    //   ADD CONSTRAINT chk_stream_type_nullability
    //   CHECK (
    //     (stream = 'standard' AND o_level IS NOT NULL AND jamb_result IS NOT NULL AND adm_letter IS NOT NULL)
    //   )
    // `);
}

export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.ENROLLMENT);
}
