import { ETables } from "../../types/db.types";
import { Knex } from "knex";

export async function up(knex: Knex): Promise<void> {
  await knex.schema.createTable(ETables.ADMIN_ROLE, t => {
    t.increments("id", { primaryKey: true })
    t.string("permissions").notNullable()
    t.string("title").notNullable().unique()
    t.string("description").nullable()
    t.timestamps(true, true)
  }).createTable(ETables.ADMIN, t => {
    t.increments("id", { primaryKey: true })
    t.string("email").unique().notNullable()
    t.string("password").notNullable()
    t.integer("role_id").unsigned()
    t.foreign("role_id").references("id").inTable(ETables.ADMIN_ROLE)
    t.string("name").notNullable()
    t.timestamps(true, true)
    t.string("username").unique()
  })
}


export async function down(knex: Knex): Promise<void> {
  await knex.schema.dropTable(ETables.ADMIN).dropTable(ETables.ADMIN_ROLE)
}

