import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Stream } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.createTable(ETables.STUDENT_FEE, (table) => {
        table.increments("id", { primaryKey: true });
        table.decimal('amount_due', 14, 2).notNullable();
        table.decimal('amount_paid', 14, 2).notNullable();
        table.decimal('balance', 14, 2).notNullable();
        table.enum('stream', Object.values(Stream));
        table.integer('year').notNullable();
        table.boolean('completed').notNullable();
        table.string('reference').notNullable();
        table.integer("diet_id").unsigned()
        table.foreign("diet_id").references("id").inTable(ETables.DIET);
        table.integer("fee_id").unsigned()
        table.foreign("fee_id").references("id").inTable(ETables.FEE);
        table.integer("student_id").unsigned()
        table.foreign("student_id").references("id").inTable(ETables.STUDENT);
        table.integer("programme_id").unsigned()
        table.foreign("programme_id").references("id").inTable(ETables.PROGRAMME);
        table.integer("session_id").unsigned()
        table.foreign("session_id").references("id").inTable(ETables.ACADEMIC_SESSION);
        table.timestamps(true, true);
    })
    // .raw(`
    //   ALTER TABLE ${ETables.STUDENT_FEE}
    //   ADD CONSTRAINT check_stream_diet_id_nullability
    //   CHECK (
    //     stream <> 'standard' AND diet_id IS NOT NULL 
    //   )
    // `);
}


export async function down(knex: Knex): Promise<void> {
    return await knex.schema.dropTable(ETables.STUDENT_FEE);
}
