import { Knex } from "knex";
import { ETables } from "../../types/db.types";
import { Gender, Status } from "../../types/enum";

export async function up(knex: Knex): Promise<void> {
    return knex.schema.alterTable(ETables.ASPIRANT, function (table) {
        table.specificType('adm_letter', 'LONGBLOB').alter();
    });
}


export async function down(knex: Knex): Promise<void> {
    return knex.schema.alterTable(ETables.ASPIRANT, function (table) {
        table.binary('adm_letter').alter();
    });
}
