import { Knex } from "knex";
import { ETables } from "../../types/db.types";

export async function up(knex: Knex): Promise<void> {
    return knex.schema.alterTable(ETables.ASPIRANT, function (table) {
        table.string('reg_no');
    })
    .alterTable(ETables.PROF_ASPIRANT, table => {
        table.string('reg_no');
    })
}


export async function down(knex: Knex): Promise<void> {
    return knex.schema.alterTable(ETables.ASPIRANT, function (table) {
        table.dropColumn('reg_no');
    })
    .alterTable(ETables.PROF_ASPIRANT, table => {
        table.dropColumn('reg_no')
    })
}
