import { Knex } from "knex";
import { ETables } from "../../types/db.types";

export async function up(knex: Knex): Promise<void> {
    return await knex.schema.alterTable(ETables.ASPIRANT, (table) => {
        table.string("jamb_result_path");
        table.string("adm_letter_path");
        table.string("o_level_path");
        table.string("passport_path");
    })
    .alterTable(ETables.PROF_ASPIRANT, table => {
        table.string('certificate_path');
        table.string('passport_path');
    })
    .alterTable(ETables.ENROLLMENT, (table) => {
        table.string('certificate_path');
        table.string("o_level_path");
        table.string("jamb_result_path");
        table.string("adm_letter_path");
        table.string("passport_path");
        table.string("passport_mimetype");
    })
}

export async function down(knex: Knex): Promise<void> {
    return await knex.schema.alterTable(ETables.ASPIRANT, (table) => {
        table.dropColumns('passport_path', 'o_level_path', 'adm_letter_path', 'jamb_result_path');
    })
    .alterTable(ETables.PROF_ASPIRANT, (table) => {
        table.dropColumns('passport_path', 'certificate_path');
    })
    .alterTable(ETables.ENROLLMENT, (table) => {
        table.dropColumns('passport_mimetype', 'passport_path', 'adm_letter_path', 'jamb_result_path', 'o_level_path', 'certificate_path');
    })
}