import { ETables } from "../../types/db.types";
import { Knex } from "knex";
import { Category, Fee_Type } from "../../types/enum";

type FEE = {
    name: string,
    description: string,
    amount: number,
    is_recurrent: boolean,
    upfront: boolean,
    category: Category,
    session: string
}

const fees: FEE[] = [
    {
        name: Fee_Type.FORM,
        description: "",
        amount: 10000,
        is_recurrent: false,
        upfront: false,
        category: Category.PROFESSIONAL,
        session: '2024/2025'
    },
    {
        name: Fee_Type.ACCEPTANCE,
        description: "",
        amount: 10000,
        is_recurrent: false,
        upfront: false,
        category: Category.PROFESSIONAL,
        session: '2024/2025'
    },
    {
        name: Fee_Type.TUITION,
        description: "",
        amount: 67000,
        is_recurrent: false,
        upfront: true,
        category: Category.BASIC,
        session: '2024/2025'
    },
    {
        name: Fee_Type.TUITION,
        description: "",
        amount: 77000,
        is_recurrent: false,
        upfront: true,
        category: Category.ADVANCED,
        session: '2024/2025'
    },
    {
        name: Fee_Type.ID_CARD,
        description: "",
        amount: 1000,
        is_recurrent: false,
        upfront: false,
        category: Category.PROFESSIONAL,
        session: '2024/2025'
    },
    {
        name: Fee_Type.ID_CARD,
        description: "",
        amount: 2000,
        is_recurrent: false,
        upfront: false,
        category: Category.NID,
        session: '2024/2025'
    },
    {
        name: Fee_Type.PUTME,
        description: "",
        amount: 2000,
        is_recurrent: false,
        upfront: false,
        category: Category.FULL,
        session: '2024/2025'
    },
    {
        name: Fee_Type.ACCEPTANCE,
        description: "",
        amount: 40000,
        is_recurrent: false,
        upfront: false,
        category: Category.FULL,
        session: '2024/2025'
    },
    {
        name: Fee_Type.TUITION,
        description: "",
        amount: 150000,
        is_recurrent: false,
        upfront: true,
        category: Category.FULL,
        session: '2024/2025'
    },
    {
        name: Fee_Type.PART_FORM,
        description: "",
        amount: 10000,
        is_recurrent: false,
        upfront: false,
        category: Category.PART,
        session: '2024/2025'
    },
    {
        name: Fee_Type.ACCEPTANCE,
        description: "",
        amount: 40000,
        is_recurrent: false,
        upfront: false,
        category: Category.PART,
        session: '2024/2025'
    },
    {
        name: Fee_Type.TUITION,
        description: "",
        amount: 165000,
        is_recurrent: false,
        upfront: true,
        category: Category.PART,
        session: '2024/2025'
    }
];

export async function seed(knex: Knex): Promise<void> {
    const new_fee: any[] = [];

    await Promise.all(fees.map(async f => {
        const sessions = await knex.select('*').from(ETables.ACADEMIC_SESSION);
        
        const session = sessions.find(ss => ss.name === f.session);
        
        if (!session) console.error('Session not found');
        
        const fe = await knex.select('*').from(ETables.FEE).where('name', f.name).andWhere('category', f.category).andWhere('session_id', session.id).first();

        const { name, description, amount, is_recurrent, upfront, category } = f;

        if(!fe) {
            new_fee.push({ name, description, amount, is_recurrent, upfront, category, session_id: session.id })
        } else {
            console.log(`Fee ${f.name} already exists`)
        }

        // delete f.session;

    }))

    new_fee.length && await knex(ETables.FEE).insert(new_fee);
}

// export async function seed(knex: Knex): Promise<void> {
//     await Promise.all(fees.map(async f => {
//         const sessions = await knex.select('*').from(ETables.ACADEMIC_SESSION);

//         const session = sessions.find(ss => ss.name === f.session);

//         if (!session) console.error('Session not found');

//         // delete f.session;
//         const { name, description, amount, is_recurrent, upfront, category } = f;

//         await knex(ETables.FEE).insert({ name, description, amount, is_recurrent, upfront, category, session_id: session.id });
//     }))
// }
