import { NextFunction, Request, Response } from "express";
import { Service } from "typedi";
import { minimatch } from "minimatch";
import { unAuthorized } from "../../Utils/api_response";
import { decodeAdminToken, decodeToken } from "../../Utils/jwt";
import AuthAdapter from "../../Database/adapters/authAdapter";
import { Permisions, permission_divider } from "../../types/enum";

@Service()
class AdminMiddleware {
  constructor (
    private readonly authAdapter: AuthAdapter
  ) {}

  public permissionGuard = (permission: Permisions) => (req: Request, res: Response, next: NextFunction) => {
    const { auth_user } = req.body;
console.log(auth_user)
console.log(permission_divider)
    const user_permissions: Permisions[] = auth_user.permissions.split(permission_divider);
    // const user_permissions: Permisions[] = auth_user.permissions
console.log(user_permissions)
console.log(permission, 'required permission')
    let allowed = false;

    for (let up of user_permissions) {
      if (minimatch(permission, up)) {
        allowed = true;
        break;
      }
      continue;
    }

    if (!allowed) {
      return unAuthorized(res, "", "You don't have permission to access this resource")
    }

    return next();
  }

  public isAuth = async (req: Request, res: Response, next: NextFunction) => {
    const { authorization } = req.headers;

    if (!authorization || !authorization.startsWith("Bearer")) {
      return unAuthorized(res, "Invalid token");
    }
    
    try {
      const token = authorization.split(" ")[1];

      const { id, email } = decodeAdminToken(token);

      const user = await this.authAdapter.IsAdminExist(id, email);
      
      if (!user) {
        return unAuthorized(res, "Invalid token");
      }

      req.body = {
        ...req.body,
        auth_user: {
          ...user
        }
      }

      return next();
    } catch (error) {
      return unAuthorized(res, "Invalid token");
    }
  }
}

export default AdminMiddleware;
