import { Router } from "express";
import { Route } from "../../Interfaces/router";
import { Inject, Service } from "typedi";
import { AuthMiddleware } from "../../Middleware";
import CourseController from "../../Controller/Course";
import CourseValidation from "../../Validations/Course";
import Injector from "../../Middleware/injector";

@Service()
class CourseRouter implements Route {
    public path: string;
    public router: Router;

    constructor(
        private readonly courseController: CourseController,
        private readonly authMiddleWare: AuthMiddleware,
        private readonly courseValidator: CourseValidation,
        private readonly injector: Injector
    ) {
        this.path = '/courses'
        this.router = Router()

        this.initializeRoutes()
    }

    private initializeRoutes () {
        this.router.get('/:stream', this.authMiddleWare.isStudentAuthenticated, this.courseValidator.validateGetCourse, this.courseController.getAllCourses);
        this.router.post('/register', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.courseValidator.validateCourseRegistration, this.courseController.register);
        this.router.get('/', this.authMiddleWare.isStudentAuthenticated, this.courseController.getMyCourses);
        this.router.delete('/:id', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.courseValidator.validateDropCourse, this.courseController.dropCourse)

        this.router.get('/course_form/generate', this.authMiddleWare.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.courseController.generateCourseForm)



    }
}

export default CourseRouter;