import { Router } from "express";
import { Route } from "../../Interfaces/router";
import { Inject, Service } from "typedi";
import { AuthMiddleware } from "../../Middleware";
import FeeController from "../../Controller/Fee";
import Injector from "../../Middleware/injector";
import FeeValidation from "../../Validations/Fee";

@Service()
class FeeRouter implements Route {
    public path: string;
    public router: Router;

    constructor(
        private readonly feeValidation: FeeValidation,
        private readonly authMiddleware: AuthMiddleware,
        private readonly injector: Injector,
        private readonly feeController: FeeController
    ) {
        this.path = '/fees'
        this.router = Router()

        this.initializeRoutes()
    }

    // need to handlle whn the student is coming foor the second year

    private initializeRoutes () {
        this.router.get('/', this.authMiddleware.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidation.validateGetOutstandingFee, this.feeController.getOutstandingFee);
        this.router.get('/pay', this.authMiddleware.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeController.payOutstandingFee);
        this.router.post('/verify', this.authMiddleware.isStudentAuthenticated, this.injector.injectCurrentSessionAndDiet, this.feeValidation.validateVerifyFeePayment, this.feeController.verifyOutstandingFeePayment);

        this.router.post('/transaction/webhook', this.injector.injectCurrentSessionAndDiet, this.feeController.paymentWebhook)

        // this.router.get('/professional/:programme_id/acceptance', this.injector.injectCurrentSessionAndDiet, this.feeValidation.validateGetAcceptanceFee, this.feeController.getProfAcceptanceFee);
        // this.router.post('/professional/:programme_id/acceptance/pay', this.injector.injectCurrentSessionAndDiet, this.feeValidation.validatePayProfAcceptanceFee, this.feeController.payProfAcceptanceFee);
        // this.router.post('/professional/:programme_id/acceptance/verify', this.injector.injectCurrentSession, this.feeValidation.validateProfAcceptanceFeePayment, this.feeController.verifyProfAcceptancePayment);

        // this.router.get('/putme', this.authMiddleware.isAspirantAuthenticated, this.injector.injectCurrentSession, this.feeController.getPutmeFee);
        // this.router.get('/putme/pay', this.authMiddleware.isAspirantAuthenticated, this.injector.injectCurrentSession, this.feeController.payPutmeFee);
        // this.router.post('/putme/verify', this.authMiddleware.isAspirantAuthenticated, this.feeValidation.validateVerifyPutmeFeePayment, this.feeController.verifyPutmePayment);
    }
}

export default FeeRouter;