import { Service } from "typedi";
import { Request, Response, Router } from "express";
import StudentRouter from "./Student";
import AspirantRouter from "./Aspirant";
import FeeRouter from "./Fee";
import AdminRouter from "./Admin";
import CourseRouter from "./Course";
import path from "path";

@Service()
class Routerr {
    public path: string;
    public router: Router;

    constructor(
        private readonly studentRouter: StudentRouter,
        private readonly aspirantRouter: AspirantRouter,
        private readonly feeRouter: FeeRouter,
        private readonly adminRouter: AdminRouter,
        private readonly courseRouter: CourseRouter,
    ) {
        this.path = '/api/v3';
        this.router = Router();

        this.initializeRoutes()
    }

    private initializeRoutes = () => {
        this.router.get('/test', (req, res) => res.status(200).json({ msg: 'Welcome to TMN_server' }))
        this.router.use(this.studentRouter.path, this.studentRouter.router);
        this.router.use(this.aspirantRouter.path, this.aspirantRouter.router);
        this.router.use(this.feeRouter.path, this.feeRouter.router);
        this.router.use(this.adminRouter.path, this.adminRouter.router);
        this.router.use(this.courseRouter.path, this.courseRouter.router);

        this.router.get('/download/:file_path', (req: Request, res: Response) => {
            const { file_path } = req.params;

            if (file_path === null || file_path === undefined || file_path === 'null') throw new Error('Invalid file');

            const decodedFilePath = decodeURIComponent(file_path);
            const filePath = path.join(__dirname, '..', '..', '..', decodedFilePath);

            res.sendFile(filePath, err => {
                if (err) {
                    console.error('Error sending file:', err);
                    res.status(500).send('Error downloading file');
                }
            });
        })
    }
}

export default Routerr;