import { readFileSync } from 'fs';
import { join } from 'path';
import { MailData } from './nodemailer';


// Define a type for the replacements to ensure type safety
interface Replacements {
    [key: string]: any;
}

export const generateContent = (fileName: string, replacements: Replacements): string => {
    const filePath = join(__dirname, fileName);
    let content: string = readFileSync(filePath, 'utf8');
    
    Object.keys(replacements).forEach((key) => {
        const regex: RegExp = new RegExp(`{{${key}}}`, 'g');
        content = content.replace(regex, replacements[key]);
    });
    return content;
}