import PDFDocument from 'pdfkit';
import blobStream from 'blob-stream';
import fs from 'fs';
import { Response } from 'express';
import { drawTable } from '../../factory';

export const generatePDF = (res: Response) => {
    try {
        // const doc = new PDFDocument();
        // let filename = encodeURIComponent('Course_Form') + '.pdf';
        // // Setting response to 'attachment' (download).
        // // If you want the PDF to be viewed, set to 'inline'
        // res.setHeader('Content-disposition', 'attachment; filename="' + filename + '"');
        // res.setHeader('Content-type', 'application/pdf');

        // const content = `Course Registration Form\n\nStudent ID: ${'studentId'}\nCourses:\n`;
        // // doc.y = 300;
        // // doc.text(content, 50, 50);


        // // studentCourses.forEach(course => {
        // //     doc.text(`${course.name} (${course.code})`, 50, doc.y);
        // // });

        // doc.pipe(res);

        // drawTable(doc, [
        //     { name: "Alice", courses: ["Mathematics", "Physics"] },
        //     { name: "Bob", courses: ["Biology", "Chemistry"] },
        //     { name: "Charlie", courses: ["History", "Geography"] },
        // ]);



        // doc.end();




        const courses = [
            { code: "CS101", title: "Introduction to Computer Science", unit: 4, semester: "Fall", type: "Core" },
            { code: "MA201", title: "Advanced Mathematics", unit: 3, semester: "Spring", type: "Elective" },
            // Add more courses as needed
        ];


        const doc = new PDFDocument();
        res.setHeader('Content-Type', 'application/pdf');
        doc.pipe(res);

        // Table headers
        const headers = ["Course Code", "Title", "Units", "Semester", "Course Status"];
        const columnWidths = [100, 200, 50, 80, 120]; // Adjust based on your needs
        const startY = 100;
        let currentY = startY;

        // Draw headers
        headers.forEach((header, i) => {
            doc.fontSize(10).text(header, 50 + columnWidths.slice(0, i).reduce((a, b) => a + b, 0), startY);
        });
        currentY += 20; // Adjust spacing as needed

        // Draw line after headers
    doc.moveTo(50, currentY).lineTo(50 + columnWidths.reduce((a, b) => a + b, 0), currentY).stroke();

    // Draw rows
    courses.forEach(course => {
        let xPosition = 50;
        currentY += 20; // Adjust for next row's Y position
        doc.text(course.code, xPosition, currentY);
        xPosition += columnWidths[0];
        doc.text(course.title, xPosition, currentY, { width: columnWidths[1], align: "left" });
        xPosition += columnWidths[1];
        doc.text(course.unit.toString(), xPosition, currentY);
        xPosition += columnWidths[2];
        doc.text(course.semester, xPosition, currentY);
        xPosition += columnWidths[3];
        doc.text(course.type, xPosition, currentY);

        // Draw a line after each row
        doc.moveTo(50, currentY + 20).lineTo(50 + columnWidths.reduce((a, b) => a + b, 0), currentY + 20).stroke();
    });

    // Optionally, draw vertical lines
    let columnStartX = 50;
    for (let i = 0; i <= headers.length; i++) {
        doc.moveTo(columnStartX, startY)
            .lineTo(columnStartX, currentY + 20) // Adjust based on the last row's Y position
            .stroke();

        // Increment X position or reset if at the end
        columnStartX += columnWidths[i] || 0;
    }

    doc.end();
    } catch (error) {
        throw error
    }
}


// export const generatePDF = (dataCb: any, endCb: any) => {
//     try {
//         const doc = new PDFDocument();
//         doc.on('data', dataCb)
//         doc.on('end', endCb)
//         doc.fontSize(25).text('Some heading');
//         doc.end()

//     } catch (error) {
//         throw error
//     }
// }

// export const generatePDF = async (res: Response) => {
//     try {
//         const doc = new PDFDocument();

//         // pipe the document to a blob
//         const stream = doc.pipe(blobStream());

//         doc.fontSize(25).text('Some heading');

//         // get a blob when you are done
//         doc.end();
//         let url
//         let blob
//         stream.on('finish', function () {
//             // get a blob you can do whatever you like with
//             blob = stream.toBlob('application/pdf');

//             // or get a blob URL for display in the browser
//             url = stream.toBlobURL('application/pdf');
//             // iframe.src = url;

//             console.log(url);
//             console.log(blob);
// stream.write(url)
//             // return url
//         })
//         // doc.pipe(url!)
//     } catch (error) {
//         throw error
//     }
// }