import { Response } from "express";
import { jsPDF } from "jspdf";
import autoTable from "jspdf-autotable";
import { Stream } from "../../../types/enum";
import fs from 'fs';
import path, { join } from 'path';
import { PartTimeFormInput } from "../../../Interfaces";
import { resizeImage } from "../../factory";
import { format } from "date-fns";

export const generateCFPDF = (res: Response, studentData: any, coursesData: any) => {
    const doc = new jsPDF();

    // Load and add school logo
    const logoPath = join('public', 'images/logo.png');
    const base64Logo = fs.readFileSync(logoPath, 'base64');
    doc.addImage(base64Logo, 'PNG', 15, 10, 35, 20); // Position logo at the top-left

    // School and document titles
    doc.setFontSize(18);
    doc.text('TNM Media Academy', 50, 20); // Adjust x coordinate to center if needed
    doc.setFontSize(12);
    doc.text('...Refining talent through innovative practical training!', 50, 27); // Below the school name

    // Student Profile Section
    doc.setFontSize(14);
    // doc.text('Student Profile', 15, 45);
    if (studentData.picture) {
        // const base64Image = fs.readFileSync(join(__dirname, '../../../../public/images/avatar2.png'), 'base64');
        const base64Image = fs.readFileSync(join('public', 'images/avatar2.png'), 'base64');
        doc.addImage(base64Image, 'PNG', 170, 32, 30, 40); // Position at the top-right
    }
    doc.setFontSize(10);
    doc.text(`Name: ${studentData.last_name} ${studentData.first_name} ${studentData.middle_name}`, 15, 55);
    doc.text(`Matric No: ${studentData.matric_no}`, 15, 65);
    doc.text(`Admission No: ${studentData.adm_no}`, 15, 75);
    doc.text(`Programme: ${studentData.stream !== 'standard' ? studentData.stream.charAt(0).toUpperCase() + studentData.stream.slice(1) + ' Professional Certificate' : 'NID Broadcast Journalism'}`, 15, 85);

    // Courses Table Section
    const columns = ["Course Code", "Title", "Units", "Course Status"];
    let body: any[] = [];
    // let currentSemester = 'first';

    coursesData.push(['GENS 221', 'English & Communication Skills', 2, 'second', 'C'])
    coursesData.push(['GENS 001', 'English & Communication Skills', 2, 'first', 'C'])

    // coursesData.forEach((course: any, index: number) => {
    //     if (course[3] !== currentSemester) {
    //         // Add a separator row when semester changes
    //         body.push([{ content: 'Second Semester Starts', colSpan: 4, styles: { fillColor: [200, 200, 255], fontStyle: 'bold', halign: 'center' } }]);
    //         currentSemester = course[3];  // Update current semester to new semester
    //     }
    //     // Add course row (excluding the 'semester' data from the array)
    //     body.push(course.slice(0, 3).concat(course[4]));
    // });

    if (studentData.stream === 'standard') {
        body.push([{ content: 'Second Semester', colSpan: 4, styles: { fillColor: [200, 200, 255], fontStyle: 'bold', halign: 'left' } }]);
        coursesData.forEach((course: any, index: number) => {
            if (course[3] !== 'first') {
                body.push(course.slice(0, 3).concat(course[4]));
            } else {
                body.unshift(course.slice(0, 3).concat(course[4]))
            }
        })
    } else {
        coursesData.forEach((course: any, index: number) => {
            body.push(course.slice(0, 3).concat(course[4]));
        })
    }

    autoTable(doc, {
        startY: 100,
        head: [columns],
        body: body,
        theme: 'grid',
        headStyles: { fillColor: [0, 0, 0], textColor: [255, 255, 255], halign: 'center' },
        bodyStyles: { fillColor: [220, 220, 220], textColor: [0, 0, 0] },
        margin: { horizontal: 10 },
        styles: { cellPadding: 2, fontSize: 9 }
    });

    // Output the PDF
    const pdfOutput = doc.output('arraybuffer');
    res.setHeader('Content-Type', 'application/pdf');
    res.setHeader('Content-Disposition', 'attachment; filename="course-form.pdf"');
    // res.send(Buffer.from(pdfOutput, 'binary'));
    res.send(Buffer.from(pdfOutput));
}

export const genAdmissionLetterPDF = (studentName: string, stream: Stream, admissionDate: Date) => {
    const doc = new jsPDF();

    // Assuming you have your Base64-encoded image string ready
    // const logoBase64 = 'data:image/png;base64,YOUR_BASE64_ENCODED_IMAGE_HERE';

    const logoPath = join('public', 'images/logo.png');
    const base64Image = fs.readFileSync(logoPath, 'base64');

    doc.addImage(base64Image, 'PNG', 90, 10, 30, 20); // Adjust as needed

    // Position the school name directly under the logo
    doc.setFontSize(12);
    doc.text('TNM Media Academy', 105, 35, { align: "center" }); // Adjust Y coordinate as needed based on logo size

    // Admission Letter heading
    doc.setFontSize(14);
    const heading = "Admission Letter";
    const headingPosition = { x: 105, y: 55 }; // Adjust Y coordinate as needed
    doc.text(heading, headingPosition.x, headingPosition.y, { align: "center" });

    // Underline the heading
    const headingWidth = doc.getTextWidth(heading);
    doc.setDrawColor(0);
    doc.setLineWidth(0.5);
    doc.line(headingPosition.x - (headingWidth / 2), headingPosition.y + 2, headingPosition.x + (headingWidth / 2), headingPosition.y + 2); // Draw line under text


    // Content of the letter
    // Prepare the letter body text
    doc.setFontSize(10);
    const textMarginLeft = 20; // Define a margin for the text
    const pageWidth = doc.internal.pageSize.getWidth();
    const maxLineWidth = pageWidth - textMarginLeft * 2; // Calculate the maximum line width for the text

    let text = `Dear ${studentName},

Congratulations! We are pleased to offer you admission to the ${stream} program at our school.

Your admission is effective as of ${admissionDate}.

Welcome to our school community.

Sincerely,
Admissions Office`;

    // Split text into lines to ensure it fits within the defined margins
    let lines = doc.splitTextToSize(text, maxLineWidth);

    // doc.text(lines, textMarginLeft, 70); // Adjust the Y position as needed

    doc.text(text, 20, 70); // Adjusted Y position to accommodate the logo

    // Save the PDF
    doc.save("admission-letter.pdf");

    console.log("Admission letter generated successfully.");

    const output = doc.output('arraybuffer');

    return output;
}

export const generateExamSlip = (student: any) => {
    const doc = new jsPDF();

    const exams = [
        { subject: "Media", code: "TVD101", date: "2024-05-10", time: "09:00 - 12:00" },
        { subject: "GNS", code: "GNS102", date: "2024-05-11", time: "13:00 - 15:00" },
        // Add more exams as needed
    ];

    // Add the school logo and exam slip details here
    doc.setFontSize(12);
    doc.text("School Name", 105, 20, { align: "center" });
    doc.text("Exam Slip", 105, 30, { align: "center" });

    // Student details
    doc.setFontSize(10);
    doc.text(`Name: ${student.last_name} ${student.first_name}`, 20, 40);
    doc.text(`Admissioon Number: ${student.adm_no}`, 20, 46);

    // Heading for the exam table
    doc.text("Subject", 20, 56);
    doc.text("Code", 70, 56);
    doc.text("Date", 100, 56);
    doc.text("Time", 140, 56);
    doc.setDrawColor(0);
    doc.line(20, 58, 190, 58); // Draw a line under headings

    // List of exams
    let currentY = 64;
    exams.forEach(exam => {
        doc.text(exam.subject, 20, currentY);
        doc.text(exam.code, 70, currentY);
        doc.text(exam.date, 100, currentY);
        doc.text(exam.time, 140, currentY);
        currentY += 6; // Adjust spacing between lines as needed
    });

    // Exam instructions or regulations
    doc.setFontSize(10);
    doc.text("Instructions:", 20, currentY + 10);
    doc.text("1. Present this slip upon entry.", 20, currentY + 16);
    doc.text("2. Arrive at least 15 minutes before the exam starts.", 20, currentY + 22);

    const output = doc.output('arraybuffer');

    return output;
}

export const generateRegistrationLetterV1 = (data: PartTimeFormInput) => {
    const doc = new jsPDF();

    const logoPath = join('public', 'images/logo.png');
    const base64Image = fs.readFileSync(logoPath, 'base64');

    doc.addImage(base64Image, 'PNG', 90, 10, 30, 20); // Adjust as needed

    // Position the school name directly under the logo
    doc.setFontSize(12);
    doc.text('TNM Media Academy', 105, 35, { align: "center" }); // Adjust Y coordinate as needed based on logo size

    // Admission Letter heading
    doc.setFontSize(14);
    const heading = "Admission Letter";
    const headingPosition = { x: 105, y: 55 }; // Adjust Y coordinate as needed
    doc.text(heading, headingPosition.x, headingPosition.y, { align: "center" });

    // Underline the heading
    const headingWidth = doc.getTextWidth(heading);
    doc.setDrawColor(0);
    doc.setLineWidth(0.5);
    doc.line(headingPosition.x - (headingWidth / 2), headingPosition.y + 2, headingPosition.x + (headingWidth / 2), headingPosition.y + 2); // Draw line under text

    // Content of the letter
    // Prepare the letter body text
    doc.setFontSize(10);
    const textMarginLeft = 20; // Define a margin for the text
    const pageWidth = doc.internal.pageSize.getWidth();
    const maxLineWidth = pageWidth - textMarginLeft * 2; // Calculate the maximum line width for the text

    const personalDetailsBody = `
    Surname: ${data.last_name}
    First Name: ${data.first_name}
    Other Name: ${data.middle_name}
    Gender: ${data.gender}
    Date of Birth: ${data.DOB}
    State of Origin: ${data.state_of_origin}
    LGA: ${data.lga}
    Phone Number: ${data.phone}
    Email: ${data.email}
    Address: ${data.address}
    `

    const ProgrammeBody = `
    Mode: Part Time
    Programme: ND
    College: Social Science
    Course: Broadcast Journalism
    `

    doc.text('Personal Details', 105, 35)
    doc.text(personalDetailsBody, 20, 70)
    doc.text('Programme', 105, 35)
    doc.text(ProgrammeBody, 20, 70)

    doc.save('Registration-Letter.pdf');

    // const output = doc.output('arraybuffer');

    // return output;

    const output = doc.output('arraybuffer');

    return output;

    // Generate PDF as Blob
    // const pdfOutput = doc.output('blob');

    // return pdfOutput; // Return the Blob
}

// export const generateRegistrationLetter = (data: PartTimeFormInput) => {
//     const doc = new jsPDF();

//     const logoPath = join('public' ,'images/logo.png');
//     const base64Image = fs.readFileSync(logoPath, 'base64');

//     doc.addImage(base64Image, 'PNG', 90, 10, 30, 20); // Adjust as needed

//     // Position the school name directly under the logo
//     doc.setFontSize(12);
//     doc.text('TNM Media Academy', 105, 35, { align: "center" }); // Adjust Y coordinate as needed

//     // Admission Letter heading
//     doc.setFontSize(14);
//     const heading = "Admission Letter";
//     const headingPosition = { x: 105, y: 55 }; // Adjust Y coordinate as needed
//     doc.text(heading, headingPosition.x, headingPosition.y, { align: "center" });

//     // Underline the heading
//     const headingWidth = doc.getTextWidth(heading);
//     doc.setDrawColor(0);
//     doc.setLineWidth(0.5);
//     doc.line(headingPosition.x - (headingWidth / 2), headingPosition.y + 2, headingPosition.x + (headingWidth / 2), headingPosition.y + 2); // Draw line under text

//     // Content of the letter
//     doc.setFontSize(10);
//     const textMarginLeft = 20; // Define a margin for the text
//     const personalDetailsBody = `
//     Surname: ${data.last_name}
//     First Name: ${data.first_name}
//     Other Name: ${data.middle_name}
//     Gender: ${data.gender}
//     Date of Birth: ${data.DOB}
//     State of Origin: ${data.state_of_origin}
//     LGA: ${data.lga}
//     Phone Number: ${data.phone}
//     Email: ${data.email}
//     Address: ${data.address}
//     `;

//     const ProgrammeBody = `
//     Mode: Part Time
//     Programme: ND
//     College: Social Science
//     Course: Broadcast Journalism
//     `;

//     doc.text('Personal Details', 105, 70, { align: 'center' });
//     doc.text(personalDetailsBody, textMarginLeft, 80);
//     doc.text('Programme', 105, 140, { align: 'center' }); // Adjust Y coordinate for clarity
//     doc.text(ProgrammeBody, textMarginLeft, 150);

//     const output = doc.output('arraybuffer');

//     return output;

//     // Generate PDF as Blob
//     // const pdfOutput = doc.output('blob');

//     // return pdfOutput; // Return the Blob
// }

export const generateApplicationForm = async (data: PartTimeFormInput) => {
    const doc = new jsPDF();

    // Function to check if a new page is needed
    const addContentWithPagination = (text: string, x: number, y: number, options = {}) => {
        const pageHeight = doc.internal.pageSize.height;
        const marginBottom = 20;

        if (y > pageHeight - marginBottom) {
            doc.addPage(); // Add a new page
            y = 20; // Reset Y position for the new page
        }
        doc.text(text, x, y, options);
        return y;
    };

    // Load logo image
    const logoPath = join('public', 'images/logo.png');
    const logoBase64 = fs.readFileSync(logoPath, 'base64');

    // Resize passport image
    const passportPath = data.passport_path;
    const passportBase64 = await resizeImage(passportPath, 150, 150, false);

    // Add logo and passport
    doc.addImage(logoBase64, 'PNG', 10, 10, 30, 20);
    doc.addImage(passportBase64, data.passport_mimetype.split('/')[1], 160, 10, 30, 30);

    // Academy Name
    doc.setFontSize(14);
    doc.setFont('helvetica', 'bold');
    doc.text('TNM Media Academy', 95, 15, { align: "center" });
    doc.setFont('helvetica', 'normal');
    doc.setFontSize(10);
    doc.text('Dugbe, Ibadan', 95, 20, { align: "center" });

    // Heading
    doc.setFontSize(16);
    const heading = "Part Time Application Form";
    let currentY = 55;
    currentY = addContentWithPagination(heading, 105, currentY, { align: "center" });

    // Personal Details Section
    doc.setFontSize(12);
    doc.setFont('helvetica', 'bold');
    currentY = addContentWithPagination('PERSONAL DETAILS', 20, currentY + 10);
    doc.setFont('helvetica', 'normal');

    doc.setFontSize(10);
    const personalDetails = [
        `Surname: ${data.last_name}`,
        `First Name: ${data.first_name}`,
        `Other Name: ${data.middle_name}`,
        `Email: ${data.email}`,
        `Gender: ${data.gender}`,
        `Date of Birth: ${format(new Date(data.DOB), 'dd/MM/yyyy')}`,
        `State of Origin: ${data.state_of_origin}`,
        `LGA: ${data.lga}`,
        `Phone Number: ${data.phone}`,
        `Address: ${data.address}`
    ];

    personalDetails.forEach(line => {
        currentY = addContentWithPagination(line, 20, currentY + 8);
    });

    // Programme Section
    doc.setFont('helvetica', 'bold');
    currentY = addContentWithPagination('PROGRAMME', 20, currentY + 15);
    doc.setFont('helvetica', 'normal');
    const programmeBody = [
        `Mode: Part Time`,
        `Programme: ND`,
        `College: Social Science`,
        `Course: Broadcast Journalism`
    ];

    programmeBody.forEach(line => {
        currentY = addContentWithPagination(line, 20, currentY + 8);
    });

    // O-Level Result Section
    doc.setFont('helvetica', 'bold');
    currentY = addContentWithPagination('O/LEVEL RESULT', 20, currentY + 15);
    doc.setFont('helvetica', 'normal');

    // Add table headers
    doc.setFont('helvetica', 'bold');
    currentY = addContentWithPagination('Subject', 20, currentY + 10);
    addContentWithPagination('Grade', 100, currentY);
    doc.setFont('helvetica', 'normal');

    // Adjust for results
    data.manual_o_level.forEach((result, index) => {
        currentY = addContentWithPagination(result['subject'], 20, currentY + 10);
        addContentWithPagination(result['grade'], 100, currentY);
    });


    // Final output
    const output = doc.output('arraybuffer');
    return output;
};


// export const generateApplicationForm = async (data: PartTimeFormInput) => {
//     const doc = new jsPDF();

//     // // Load logo image
//     // const logoPath = path.join(__dirname, '../../../../public/images/logo.png');
//     const logoPath = join('public' ,'images/logo.png');
//     const logoBase64 = fs.readFileSync(logoPath, 'base64');

//     // // const passportBase64 = data.passport.toString('base64');

//     // let passportBase64 = '';
//     // if (typeof data.passport_path === 'string') {
//     //     // const passportPath = path.join(process.env.UPLOAD_PATH ?? 'uploads', data.passport_path);  // Assuming 'data.passport' is a filename in 'uploads'
//     //     const passportPath = data.passport_path;
//     //     passportBase64 = fs.readFileSync(passportPath, 'base64');
//     // } else {
//     //     // If passport is passed as buffer (for testing or fallback)
//     //     passportBase64 = data.passport.toString('base64');
//     // }

//     const passportPath = data.passport_path;
//     const passportBase64 = await resizeImage(passportPath, 150, 150, false); // Resize passport

//     // Add logo at the top left
//     doc.addImage(logoBase64, 'PNG', 10, 10, 30, 20); // Adjust size and position

//     // Add passport image at the top right
//     doc.addImage(passportBase64, data.passport_mimetype.split('/')[1], 160, 10, 30, 30); // Adjust size and position

//     // Academy Name positioned between the logo and passport image, aligned with top images
//     doc.setFontSize(14);
//     doc.setFont('helvetica', 'bold');
//     doc.text('TNM Media Academy', 95, 15, { align: "center" });
//     doc.setFont('helvetica', 'normal');
//     doc.setFontSize(10);
//     doc.text(' Dugbe, Ibadan', 95, 20, { align: "center" });

//     // Admission Letter Heading
//     doc.setFontSize(16);
//     const heading = "Part Time Application Form";
//     const headingPosition = { x: 105, y: 55 };
//     doc.text(heading, headingPosition.x, headingPosition.y, { align: "center" });

//     // Underline the heading
//     const headingWidth = doc.getTextWidth(heading);
//     doc.setDrawColor(0);
//     doc.setLineWidth(0.5);
//     doc.line(
//         headingPosition.x - (headingWidth / 2), headingPosition.y + 2,
//         headingPosition.x + (headingWidth / 2), headingPosition.y + 2
//     );

//     // Personal Details Section with Registration Number on the right
//     doc.setFontSize(12);
//     doc.setFont('helvetica', 'bold');
//     doc.text('PERSONAL DETAILS', 20, 80);
//     doc.setFont('helvetica', 'normal');
//     doc.text(`Registration No: ${data.reg_no}`, 190, 80, { align: 'right' }); // Registration No on the far right

//     // Increase line spacing in Personal Details
//     const lineSpacing = 8; // Adjust line spacing
//     const personalDetailsBody = [
//         `Surname: ${data.last_name}`,
//         `First Name: ${data.first_name}`,
//         `Other Name: ${data.middle_name}`,
//         `Email: ${data.email}`,
//         `Gender: ${data.gender}`,
//         `Date of Birth: ${format(new Date(data.DOB), 'dd/MM/yyyy')}`,
//         `State of Origin: ${data.state_of_origin}`,
//         `LGA: ${data.lga}`,
//         `Phone Number: ${data.phone}`,
//         `Address: ${data.address}`,
//     ];

//     doc.setFontSize(10);
//     personalDetailsBody.forEach((line, index) => {
//         doc.text(line, 20, 90 + index * lineSpacing);
//     });

//     // Programme Section
//     doc.setFontSize(12);
//     doc.setFont('helvetica', 'bold');
//     doc.text('PROGRAMME', 20, 190); // Section title
//     doc.setFont('helvetica', 'normal');

//     const programmeBody = [
//         `Mode: Part Time`,
//         `Programme: ND`,
//         `College: Social Science`,
//         `Course: Broadcast Journalism`
//     ];

//     programmeBody.forEach((line, index) => {
//         doc.text(line, 20, 200 + index * lineSpacing);
//     });

//     // O-Level Result Section
//     doc.setFontSize(12);
//     doc.setFont('helvetica', 'bold');
//     doc.text('O/LEVEL RESULT', 20, 250); // Section title
//     doc.setFont('helvetica', 'normal');

//     // Draw a table for results
//     doc.setFontSize(10);
//     doc.text('Subject', 20, 260);
//     doc.text('Grade', 100, 260);

//     data.manual_o_level.forEach(result => {
//         doc.text(result['subject'], 20, 270);
//         doc.text(result['grade'], 100, 270);
//     })
//     // doc.text('Mathematics', 20, 270);
//     // doc.text('A1', 100, 270);
//     // doc.text('English', 20, 280);
//     // doc.text('C6', 100, 280);

//     const output = doc.output('arraybuffer');

//     return output;
// };
