import Validator from "..";
import { Service } from 'typedi';
import { Level, PROF_Stream, Semester, Stream, } from '../../types/enum';
import { CourseValidatorAdapter } from '../../Database/adapters/courseAdapter';
import { FeeValidatorAdapter } from "../../Database/adapters/feeAdapter";
import { StudentValidatorAdapter } from "../../Database/adapters/studentAdapter";

@Service()
class CourseValidation extends Validator {
    constructor(
        private readonly courseValAdapter: CourseValidatorAdapter,
        private readonly feeValAdapter: FeeValidatorAdapter,
        private readonly studentValAdapter: StudentValidatorAdapter
    ) {
        super()
    }

    public validateGetCourse = this.validate({
        stream: {
            in: ['params'],
            isIn: { options: [Object.values(Stream)] },
        }
    })

    public validateCourseRegistration = this.validate({
        ids: {
            in: 'body',
            isArray: { options: { min: 1 } },
            notEmpty: true,
            isInt: true,
            custom: {
                options: async (ids, { req }) => {
                    const { auth_user, session } = req.body;

                    if (new Set(ids).size !== ids.length) throw new Error('The courses must be unique');

                    const student = await this.studentValAdapter.DBGetStudent(auth_user.matric_no);
                    // if (student.stream !== Stream.STANDARD) {
                    if (Object.values(PROF_Stream).includes(student.stream)) {
                        const courses = await this.courseValAdapter.DBGetAllCourses(student.stream);

                        const picked_all = courses.every(course => ids.some((id: any) => course.id === id));

                        const sameLength = courses.length === ids.length;

                        if (!(picked_all && sameLength)) throw new Error('You are required to select all the courses available for your programme');

                        const registered = await this.courseValAdapter.DBHasCourseForCurrentSession(ids[0], auth_user.id, session.id);

                        if (registered) throw new Error(`Courses already registered!. You can't register the same course in a session`);
                    } else {
                        // check if courses are valid
                        for (let id of ids) {
                            const exist = await this.courseValAdapter.DBGetCourseById(id);

                            if (!exist) throw new Error(`One of the course is invalid`);

                            //check if registered before in the current session
                            const registered = await this.courseValAdapter.DBHasCourseForCurrentSession(id, auth_user.id, session.id);

                            if (registered) throw new Error(`Course ${exist.code} already registered!. You can't register the same course in a session`);
                        }
                    }


                }
            }
        }
    })

    public validateDropCourse = this.validate({
        id: {
            in: 'params',
            isInt: true,
            custom: {
                options: async (id, {req}) => {
                    const { auth_user, session } = req.body;
                    const exist = await this.courseValAdapter.DBGetCourseById(id);

                    if(!exist) throw new Error('Invalid course');
console.log(id)
                    const hasCourse = await this.courseValAdapter.DBHasCourseForCurrentSession(id, auth_user.id, session.id);
console.log(hasCourse)
                    if(!hasCourse) throw new Error('Yet to registered for the specified course');
                }
            }
        }
    })
}

export default CourseValidation;