import { badRequest } from '../Utils/api_response';
import { NextFunction, Request, Response } from 'express';
import { Schema, ValidationError, checkSchema, validationResult } from 'express-validator';
import { deleteFiles } from '../Utils/multer';

class Validator {
  public validate = (schema: Schema) => async (req: any, res: Response, next: NextFunction) => {
    await Promise.all(checkSchema(schema).map(validation => validation.run(req)));
    const errors = validationResult(req);
    if (errors.isEmpty()) {
      return next();
    }
console.log(req.uploadedFiles, 'req.uploadedFiles')
    if (req.uploadedFiles && req.uploadedFiles.length > 0) {
      deleteFiles(req.uploadedFiles);
    }

    // const errs: ValidationError[] = errors.array() as any
    const errs = errors.array() as any

    const message = errs[0].msg == 'Invalid value' ? `${errs[0].msg} at ${errs[0].path}` : errs[0].msg
    return badRequest(res, errs, message);
  };
}

export default Validator;
